/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IPaster.java,v 1.2 2005/06/09 09:34:10 jgout Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.navigator.actions;

import org.eclipse.swt.dnd.Clipboard;

/** Interface used by testNavigatorPasteExtension.
 * 
 * @author jgout
 * @since 3.3
 */
public interface IPaster {
	
    /**
     * Returns whether a paste action is allowed according to the content of the given clipboard and the destination selected element or not.
     * @param clipboard a clipboard
     * @param selection the selected destination element in which the paste action is going to perform.
     * @return
     */
	public boolean isPasteAllowedFor(Clipboard clipboard, Object selection);
	
    /**
     * Performs the paste action on the client side.
     * @param clipboard the clipboard in which data can be retrieve.
     * @param selection the destination container element in which the paste has to perform.
     * @return a boolean that indicates that the test navigator has to be refreshed after this paste action.
     */
	public boolean performPaste(Clipboard clipboard, Object selection);
}
