/********************************************************************** 
 * Copyright (c) 2008 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: IProxyNodePaster.java,v 1.1 2008/03/20 19:49:55 paules Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/
package org.eclipse.hyades.test.ui.navigator.actions;

import org.eclipse.core.runtime.IPath;
import org.eclipse.ltk.core.refactoring.Change;

/**
 * Interface that allows to describe the paste behavior of a proxy node.
 * 
 * @author Jerome Bozier
 * @version February 26, 2008
 * @since 4.5
 * @provisional Provisional API as of TPTP 4.5.0.
 */
public interface IProxyNodePaster {
	/**
	 * Returns the refactoring change when pasting this instance to the new destination path.
	 * The given context can be used if the local change cannot be perform without a global context.
	 * This can be performed using an IRefactoringTransaction (retrieved by its domain Id) to collect 
	 * data. Such refactoring transaction will performed changes in one time.
	 * create a new proxy on dest location + copy proxy link if any
	 *   
	 * @param context a context that contains all IRefactoringTransaction instances defined by clients.
	 * @param newPath the destination path of this proxy node.
	 * @param targetName a 1 element array that will contain newly pasted proxy file name after call
	 * @return the change that performs the paste of the proxy node to the given destination path.
	 */
	public Change createPasteChange(IRefactoringContext context, IPath destinationPath,String [] targetName);

}
