/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IProxyNodeRenamer.java,v 1.6 2008/03/20 19:49:55 paules Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.ui.navigator.actions;


/** This interface is used by client to provider "rename" action support 
 * on IProxyNode found in the test navigator.
 * 
 * @author jgout
 * @since 3.3
 * @version February 26, 2008
 * @deprecated client should use IProxyNodeRenamer2 instead.
 */
public interface IProxyNodeRenamer {
	
	/** Returns whether this renamer is applicable for the adapted proxy or not. 
	 * 
	 * @return <code>true</code> if rename can be done and <code>false</code> otherwise.
	 */
	public boolean isApplicableFor();
	
	/** Performs the GUI interaction in order to get the new name.
	 *  This method allows extenders to provide a specific GUI to retrieve the the new name (e.g. own dialog), 
	 *  but they can use the default behavior as well.  
	 * @param oldName the string containing the current name before renaming.
	 * @return One instance of the the following subclasses of <code>RenamerUIStatus</code> class:
	 * <ul>
	 * <li><code>org.eclipse.hyades.test.ui.navigator.actions.RenamerUIOk</code>: 
	 * 			this means that rename action calls a specific GUI in order to get the new name and 
	 * 			this GUI ends properly. The new name can be accessed through the <code>RenameUIOK.getNewName(),</code></li>
	 * <li><code>org.eclipse.hyades.test.ui.navigator.actions.RenamerUICancel</code>:
	 * 			this means that rename action calls a specific GUI in order to get the new name and 
	 * 			this GUI has been aborted by user. There is no new name set and the action needs to be aborted.</li>
	 * <li><code>org.eclipse.hyades.test.ui.navigator.actions.RenamerUIInlineEditor</code>: 
	 * 			this means that rename action uses the default inline editor in order to get the new name. The name is internaly passed to the method <code>IProxyNodeRenamer.performRename(String newName)</li>
	 * </ul> 
	 */
	public RenamerUIStatus performUserInteraction(String oldName);
	
	/** Performs the actual rename task on proxy node and referenced object.
	 * 
	 * @param newName the new name of the proxy node.
	 * @return boolean whether test navigator should be refreshed after the rename is applied.
	 */
	public boolean performRename(String newName);
}
