/********************************************************************** 
 * Copyright (c) 2008 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: IProxyNodeRenamer2.java,v 1.1 2008/03/20 19:49:55 paules Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/
package org.eclipse.hyades.test.ui.navigator.actions;

import org.eclipse.ltk.core.refactoring.Change;

/**
 * Interface that allows to describe the rename behavior of a proxy node.
 * 
 * @author jgout
 * @version February 26, 2008
 * @since 4.5
 * @provisional Provisional API as of TPTP 4.5.0.
 */
public interface IProxyNodeRenamer2 {

	/**
	 * Returns the refactoring change when renaming this instance with the new name.
	 * The given context can be used if the local change cannot be perform without a global context.
	 * This can be performed using an IRefactoringTransaction (retrieved by its domain Id) to collect 
	 * data. Such refactoring transaction will performed changes in one time.
	 *   
	 * @param context a context that contains all IRefactoringTransaction instances defined by clients.
	 * @param newName the new name of this proxy node.
	 * @return the change that performs the rename of the proxy node using the given new name.
	 */
	public Change createRenameChange(IRefactoringContext context, String newName);
}
