/********************************************************************** 
 * Copyright (c) 2008 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: IProxyNodeUpdater.java,v 1.1 2008/03/20 19:49:55 paules Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/
package org.eclipse.hyades.test.ui.navigator.actions;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.hyades.test.ui.navigator.IReferencerProxyNode;
import org.eclipse.ltk.core.refactoring.Change;

/**
 * Interface that allows to describe the update behavior of a proxy node.
 * 
 * @author jgout
 * @version February 26, 2008
 * @since 4.5
 * @provisional Provisional API as of TPTP 4.5.0.
 */
public interface IProxyNodeUpdater {

	/**
	 * Returns the refactoring change when an instance need to be updated according the move/delete of a referencer proxy node.
	 * The given context can be used if the local change cannot be perform without a global context.
	 * This can be performed using an IRefactoringTransaction (retrieved by its domain Id) to collect 
	 * data. Such refactoring transaction will performed changes in one time.
	 * The destination path can be <code>null</code>, this means that this instance need to be updated according to the deletion of the given <code>referencer</code>.
	 * For instance a test can update its state when one of its invoked test is deleted.
	 *  
	 * @param context a context that contains all IRefactoringTransaction instances defined by clients.
	 * @param referencer the proxy node that has changed and implies the update of this instance. (<code>referencer.getReferences(refType).contains(this) == true</code>)
	 * @param refType the type of the reference between this instance and <code>referencer</code>. 
	 * @param newPath the destination path of this proxy node. This parameter is <code>null</code> when the reason of the update is a delete.
	 * @return the change that performs the update of instance following a move of a reference to itself.
	 */
	public Change createUpdateChange(IRefactoringContext context, IReferencerProxyNode referencer, String refType, IPath destinationPath);
	
	/**
	 * Returns the refactoring change when an instance need to be updated according the change of its container.
	 * The given context can be used if the local change cannot be perform without a global context.
	 * This can be performed using an IRefactoringTransaction (retrieved by its domain Id) to collect 
	 * data. Such refactoring transaction will performed changes in one time.
	 * 
	 * @param context a context that contains all IRefactoringTransaction instances defined by clients.
	 * @param container the container that has changed and that implies the update of this instance.
	 * @param destinationPath the new path of the instance.
	 * @return the change that performs the update of instance following a rename of the given container to the given path.
	 */
	public Change createUpdateChange(IRefactoringContext context, IContainer container, IPath destinationPath);

}
