/********************************************************************** 
 * Copyright (c) 2008 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: IRefactoringContext.java,v 1.1 2008/03/20 19:49:55 paules Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/
package org.eclipse.hyades.test.ui.navigator.actions;

import org.eclipse.hyades.test.ui.navigator.IRefactoringTransaction;

/**
 * Global context that contents all domain specific refactoring transactions defined using 
 * the extension point <code>org.eclipse.hyades.test.ui.testNavigatorRefactoringTransactions</code>
 * This interface is not intented to be implemented by clients.
 * 
 * @author jgout
 * @version February 26, 2008
 * @since 4.5
 * @provisional Provisional API as of TPTP 4.5.0.
 */
public interface IRefactoringContext {

	/**
	 * Returns the refactoring transaction given its domain id.
	 * @param domainId a domain id.
	 * @return the refactoring transaction given its domain id or <code>null</code> if the domain id is unknown.
	 */
	public IRefactoringTransaction getRefactoringTransaction(String domainId);
}
