/**********************************************************************
 * Copyright (c) 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id$
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.ui.navigator.actions;

/**
 * This class contains the status of the UI interaction of the rename action.
 * An instance of this class is returned by the method <code>IProxyNodeRenamer.performUserInteraction</code>.
 * This status is composed of a flag and the new name of the renamed element in certain case.
 * The flag values mean:
 * <ul>
 * <li> <code>OK</code> means thas a dedicated UI dialog has been successfully terminated and the new name should be stored in the status and available through <code>getNewName()</code>).</li>
 * <li> <code>CANCEL</code> means thas a dedicated UI dialog has been called but it has been cancel before a new name has been set.</li>
 * <li> <code>INLINE_EDITOR</code> means that a inline editor has been used. The new name is automatically passed in that case.</li>
 * </ul>
 * 
 * One public instance of each case have been declared and clients are supposed to use those instances.
 * 
 * @see org.eclipse.hyades.test.ui.navigator.actions.IProxyNodeRenamer#performUserInteraction(String)
 * @see org.eclipse.hyades.test.ui.navigator.actions.RenamerUIOk
 * @see org.eclipse.hyades.test.ui.navigator.actions.RenamerUICancel
 * @see org.eclipse.hyades.test.ui.navigator.actions.RenamerUIInlineEditor
 * 
 * @author jgout
 * @since 3.3
 * @version February 26, 2008
 * @deprecated this class is no longer needed
 */
public class RenamerUIStatus {

	public static final int OK = 0;
	public static final int CANCEL = 1;
	public static final int INLINE_EDITOR = 2;
	
	private int status;
	private String newName;
	
    /**
     *  Constructor
     * @param status which kind of status (OK, CANCEL or INLINE_EDITOR)
     * @param name the new name of the renamed proxy node.
     */
	public RenamerUIStatus(int status, String name) {
		this.status = status;
		this.newName = name;
	}
	
    /**
     * Getter for the new name of the renamed proxy node.
     * @return the new name of the renamed proxy node.
     */
	public String getNewName() {
		return newName;
	}
    
	/**
     * Returns the kind of the status one of (OK, CANCEL or INLINE_EDITOR).
     * @return the kind of the status one of (OK, CANCEL or INLINE_EDITOR).
	 */
	public int getStatus() {
		return status;
	}
}
