/**********************************************************************
 * Copyright (c) 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: 
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.ui.navigator.refactoring;

import org.eclipse.ltk.core.refactoring.Change;

/**
 * <p>Abstract {@link Change} extension to resolve the new name of a 
 * paste {@link Change}.</p>
 * 
 * 
 * @author  Jerome Bozier
 * @author  Paul Slauenwhite
 * @since   November 3, 2009
 * @version November 3, 2009
 * @provisional As of TPTP V4.6.2, this is stable provisional API (see http://www.eclipse.org/tptp/home/documents/process/development/api_contract.html).
 */
public abstract class AbstractPasteChange extends Change {

	/**
	 * <p>Resolves the new name of the paste {@link Change}.</p>
	 * 
	 * @return The new name of the paste {@link Change}.
	 */
	public abstract String getNewName();
}
