/********************************************************************** 
 * Copyright (c) 2009 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id:  
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/
package org.eclipse.hyades.test.ui.navigator.refactoring;

import org.eclipse.core.resources.IResource;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;

/**
 * event containing informations for refactoring listener when a delete action is performed
 * @author jbozier
 * @since 4.5.2
 * @version January 12, 2009
 * @provisional
 */
public class DeleteRefactoringEvent extends RefactoringEvent {

	/**
	 * constructor used when deleting a IProxyNode
	 * @param node : deleted IProxyNode
	 * @provisional
	 */
	public DeleteRefactoringEvent(IProxyNode node) {
		super(node,ITestNavigatorRefactoringListener.KIND_DELETE);
	}
	
	/**
	 * constructor used when deleting a IResource (container or file without proxy)
	 * @param node : deleted IResource
	 * @provisional
	 */
	public DeleteRefactoringEvent(IResource resource) {
		super(resource,ITestNavigatorRefactoringListener.KIND_DELETE);
	}

}
