/*******************************************************************************
 * Copyright (c) 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: 
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.navigator.refactoring;

/**
 * interface implemented by refactoring listener
 * @author jbozier
 * @since 4.5.2
 * @version January 12, 2009
 * @provisional
 */

public interface ITestNavigatorRefactoringListener {

	public static final int KIND_MOVE 			 = 0; // move refactoring (item's parent changes)
	public static final int KIND_RENAME 		 = 1; // rename refactoring (item's parent stay the same)
	public static final int KIND_DELETE 		 = 2; // delete refactoring
	public static final int KIND_PASTE 			 = 3; // copy/paste refactoring (trigger during paste)
	public static final int KIND_UPDATE_SELF 	 = 4; // update item when its location changes
	public static final int KIND_UPDATE_EXTERNAL = 5; // update item when one of the items it references changes
	
	public static final int KIND_NUMBER 		 = 6; // number of kind of refactoring
	
	/**
	 * this method is called at start of a refactoring action
	 * @param event : event containing refactoring description
	 * @provisional
	 */
	public void start(RefactoringEvent event);
	
	/**
	 * this method is called at end of a refactoring action
	 * @param event : event containing refactoring description
	 * @provisional
	 */
	public void end(RefactoringEvent event);
	
	/**
	 * this method is called to know if listener is enable or not for the start method 
	 * @return true if listener is enable for the start method 
	 * @provisional
	 */
	public boolean startEnable();

	/**
	 * this method is called to know if listener is enable or not for the end method 
	 * @return true if listener is enable for the end method 
	 * @provisional
	 */
	public boolean endEnable();

	/**
	 * this method is called to know on which kind of refactoring event the listener have to be trigger
	 * @return : kind of event in this list :
	 *   KIND_MOVE 	          : move refactoring (item's parent changes)
	 *   KIND_RENAME          : rename refactoring (item's parent stay the same)
	 *   KIND_DELETE          : delete refactoring
	 *   KIND_PASTE           : copy/paste refactoring (trigger during paste)
	 *   KIND_UPDATE_SELF     : update item when its location changes if it contains references to other items
	 *   KIND_UPDATE_EXTERNAL : update item when one of the items it references changes
	 * @provisional
	 */
	public int getKind();
}
