/*******************************************************************************
 * Copyright (c) 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: 
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.navigator.refactoring;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;

/**
 * event containing informations for refactoring listener when a move action is performed
 * @author jbozier
 * @since 4.5.2
 * @version January 12, 2009
 * @provisional
 */
public class MoveRefactoringEvent extends RefactoringEvent {
	private IContainer dest;
	
	/**
	 * constructor used when moving a IProxyNode into dest container
	 * @param node : moved IProxyNode
	 * @param dest : target container
	 * @provisional
	 */
	public MoveRefactoringEvent(IProxyNode node, IContainer dest) {
		super(node,ITestNavigatorRefactoringListener.KIND_MOVE);
		this.dest = dest;
	}
	
	/**
	 * constructor used when moving a IFolder into dest container
	 * @param folder : moved IFolder
	 * @param dest : target container
	 * @provisional
	 */
	public MoveRefactoringEvent(IFolder folder, IContainer dest) {
		super(folder,ITestNavigatorRefactoringListener.KIND_MOVE);
		this.dest = dest;
	}
	
	/**	 
	 * return target container
	 * @provisional
	 */
	public IContainer getDest() {
		return dest;
	}
}
