/*******************************************************************************
 * Copyright (c) 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: 
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.navigator.refactoring;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;

/**
 * event containing informations for refactoring listener when a paste action is performed
 * @author jbozier
 * @since 4.5.2
 * @version January 12, 2009
 * @provisional
 */
public class PasteRefactoringEvent extends RefactoringEvent {
	private IContainer dest;
	
	/**
	 * constructor used when pasting a IProxyNode into dest container
	 * @param node : pasted IProxyNode
	 * @param dest : target container
	 * @provisional
	 */
	public PasteRefactoringEvent(IProxyNode node, IContainer dest) {
		super(node,ITestNavigatorRefactoringListener.KIND_PASTE);
		this.dest = dest;
	}
	
	/**
	 * constructor used when pasting a IResource into dest container
	 * @param resource : pasted IResource
	 * @param dest : target container
	 * @provisional
	 */
	public PasteRefactoringEvent(IResource resource, IContainer dest) {
		super(resource,ITestNavigatorRefactoringListener.KIND_PASTE);
		this.dest = dest;
	}
	
	/**
	 * constructor used when pasting an external resource into dest container
	 * @param externalFileName : pasted external resource
	 * @param dest : target container
	 * @provisional
	 */
	public PasteRefactoringEvent(String externalFileName, IContainer dest) {
		super(externalFileName,ITestNavigatorRefactoringListener.KIND_PASTE);
		this.dest = dest;
	}

	/**	 
	 * return target container
	 * @provisional
	 */
	public IContainer getDest() {
		return dest;
	}
}
