/*******************************************************************************
 * Copyright (c) 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: 
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.navigator.refactoring;

import org.eclipse.core.resources.IResource;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;

/**
 * event containing informations for refactoring listener
 * this class is not designed to be directly instancied
 * @author jbozier
 * @since 4.5.2
 * @version January 9, 2009
 * @provisional
 */
public class RefactoringEvent {
	private Object item; // item on which the refactoring is performed
	private int kind;    // kind of refactoring
	
	/**
	 * constructor used to store information on an event relative to a IProxyNode
	 * @param node : node relative to the event
	 * @param kind : kind of event (see ITestNavigatorRefactoringListener for full list)
	 * @provisional
	 */
	public RefactoringEvent(IProxyNode node,int kind) {
		this.item = node;
		this.kind = kind;
	}
	
	/**
	 * constructor used to store information on an event relative to a IResource
	 * @param resource : resource relative to the event
	 * @param kind : kind of event (see ITestNavigatorRefactoringListener for full list)
	 * @provisional
	 */
	public RefactoringEvent(IResource resource,int kind) {
		this.item = resource;
		this.kind = kind;
	}

	/**
	 * constructor used to store information on an event relative to an external resource
	 * @param externalFileName : name of external resource relative to the event
	 * @param kind : kind of event (see ITestNavigatorRefactoringListener for full list)
	 * @provisional
	 */
	public RefactoringEvent(String externalFileName,int kind) {
		this.item = externalFileName;
		this.kind = kind;
	}
	
	/**
	 * return the kind of event (see ITestNavigatorRefactoringListener for full list)
	 * @return
	 * @provisional
	 */
	public int getKind() {
		return kind;
	}
		
	/**
	 * return the item relative to the event (IProxyNode, IResource or String)
	 * @return
	 * @provisional
	 */
	public Object getItem() {
		return item;
	}
}
