/*******************************************************************************
 * Copyright (c) 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: 
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.navigator.refactoring;

import org.eclipse.core.resources.IContainer;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;

/**
 * event containing informations for refactoring listener when a rename action is performed
 * @author jbozier
 * @since 4.5.2
 * @version January 12, 2009
 * @provisional
 */
public class RenameRefactoringEvent extends RefactoringEvent {
	private String name;
	
	/**
	 * constructor used when renaming a IProxyNode into name
	 * @param node : renamed IProxyNode
	 * @param name : target name
	 * @provisional
	 */
	public RenameRefactoringEvent(IProxyNode node,String name) {
		super(node,ITestNavigatorRefactoringListener.KIND_RENAME);
		this.name = name;
	}
	
	/**
	 * constructor used when renaming a IContainer into name
	 * @param container : renamed IContainer
	 * @param name : target name
	 * @provisional
	 */
	public RenameRefactoringEvent(IContainer container,String name) {
		super(container,ITestNavigatorRefactoringListener.KIND_RENAME);
		this.name = name;
	}
	
	/**
	 * return target name
	 * @return
	 * @provisional
	 */
	public String getName() {
		return name;
	}
}
