/*******************************************************************************
 * Copyright (c) 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: 
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.navigator.refactoring;

import org.eclipse.hyades.test.ui.internal.navigator.refactoring.TestNavigatorRefactoringListenerManager;

/**
 * this class is a simple factory to let user add/remove listeners to refactoring events
 * @author jbozier
 * @since 4.5.2
 * @version January 12, 2009
 * @provisional
 */

public class TestNavigatorRefactoringListenerFactory {

	private TestNavigatorRefactoringListenerManager manager = null;
	private static TestNavigatorRefactoringListenerFactory instance = null;
	
	private TestNavigatorRefactoringListenerFactory() {
		manager = TestNavigatorRefactoringListenerManager.getInstance();
	}
	
	/**
	 * this method return an instance of the factory
	 * @return : instance of the factory
	 * @provisional
	 */
	public static TestNavigatorRefactoringListenerFactory getInstance() {
		if (instance == null) {
			instance = new TestNavigatorRefactoringListenerFactory();
		}
		return instance;
	}
	
	/**
	 * this method add a listener on a kind of refactoring event
	 * @param listener : listener to add
	 * @provisional
	 */
	public void addListener(ITestNavigatorRefactoringListener listener) {
		manager.addListener(listener);
	}
	
	/**
	 * this method remove a previously added listener
	 * @param listener : listener to remove
	 * @provisional
	 */
	public void removeListener(ITestNavigatorRefactoringListener listener) {
		manager.removeListener(listener);
	}
}
