/*******************************************************************************
 * Copyright (c) 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: 
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.navigator.refactoring;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.reference.CompositeReferencerProxyNode;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;

/**
 * event containing informations for refactoring listener when an update action is performed on a proxy
 * @author jbozier
 * @since 4.5.2
 * @version January 12, 2009
 * @provisional
 */
public class UpdateRefactoringEvent extends RefactoringEvent {
	private String type;
	private IPath dest;
	private CompositeReferencerProxyNode ref;
	private IContainer source;
	
	/**
	 * constructor used when updating a IProxyNode that reference another proxy with type kind of link that changes directory (external update)
	 * @param node : updated IProxyNode
	 * @param ref : referenced proxy that have moved
	 * @param type : type of link beetwen node and ref
	 * @param dest : target container where referenced proxy moved
	 * @provisional
	 */
	public UpdateRefactoringEvent(IProxyNode proxy,CompositeReferencerProxyNode ref,String type,IPath dest) {
		super(proxy,ITestNavigatorRefactoringListener.KIND_UPDATE_EXTERNAL);
		this.ref = ref;
		this.type = type;
		this.dest = dest;
		this.source = null;
	}
	
	/**
	 * constructor used when updating a IProxyNode that reference other proxy changes directory (self update)
	 * @param node : updated IProxyNode
	 * @param source : parent container of node
	 * @param dest : target container where node is moved
	 * @provisional
	 */
	public UpdateRefactoringEvent(IProxyNode proxy,IContainer source,IPath dest) {
		super(proxy,ITestNavigatorRefactoringListener.KIND_UPDATE_SELF);
		this.source = source;
		this.dest = dest;
		this.type = null;
		this.ref = null;
	}
	
	/**
	 * return parent container of node in kind of a self update, null else
	 * @return
	 * @provisional
	 */
	public IContainer getSource() {
		return source;
	}
	
	/**
	 * return referenced proxy in case of an external update, null else
	 * @return
	 * @provisional
	 */
	public CompositeReferencerProxyNode getRef() {
		return ref;
	}
	
	/**
	 * return type of reference beetwen proxy and referenced proxy in case of external update, null else
	 * @return
	 * @provisional
	 */
	public String getType() {
		return type;
	}
	
	/**
	 * return target container for the move
	 * @return
	 * @provisional
	 */
	public IPath getDest() {
		return dest;
	}
}
