/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id$
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.ui.recorder.util;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.hyades.execution.recorder.Recorder;
import org.eclipse.hyades.execution.recorder.RecorderFactory;
import org.eclipse.hyades.internal.execution.recorder.ui.RecorderClientUI;
import org.eclipse.hyades.internal.execution.recorder.ui.views.RecorderControlView;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.tptp.test.internal.recorder.ui.wizards.IRecorderWizard;

/**
 * @author jnevicos
 *
 */
public class RecorderUtil {

	
	/**
	 * Starts a recorder, while initializing the default listeners.
	 * 
	 * @param recorder - the Recorder to launch, this should be created via the Recorder extension point
	 * @param wizard - the wizard used to launch the recorder.  This is needed to query for additional status listeners.
	 */
	public static void launchRecorder(final Recorder recorder, IRecorderWizard wizard)
	{

			//register recorder control view
			RecorderFactory.getInstance().addListener(RecorderControlView.getInstance());
			RecorderFactory.getInstance().addListener(new RecorderClientUI(recorder, wizard));
			if (wizard != null)
				wizard.registerListeners();  //register additional listeners
			
			Job job = new Job(UiPluginResourceBundle.RecorderClientUI_INIT_JOB) {
				protected IStatus run(IProgressMonitor monitor) {
					try {
						recorder.Record(monitor);
					}
					catch (Exception e)
					{
						if(recorder!=null)	
							recorder.setActive(false);
						e.printStackTrace();
						RecorderControlView.getInstance().addMessage(UiPluginResourceBundle.RecorderClientUI_RECORDING_ABORTED_DUE_TO_EXCEPTION_MESSAGE+e.getMessage()); 
						return Status.CANCEL_STATUS;
					} 
					return Status.OK_STATUS;
				}
			};
			job.setUser(true);
			job.schedule();

	}

}
