/**********************************************************************
 * Copyright (c) 2005, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: RCPFileEditorInput.java,v 1.4 2009/10/27 18:42:11 paules Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.ui.util;

import java.io.File;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.PlatformUI;

/**
 * <p>This class is used to represent an editor input that is not from within the workspace.
 * As opposed to {@link org.eclipse.ui.IFileEditorInput IFileEditorInput}, which only works
 * for workspace file. This class is especially useful Rich Client Platform (RCP) where there
 * is no project and editor input can be from anywhere in the file system.</p> 
 * 
 * 
 * @author  Peter Sun
 * @author  Bianca Xue Jiang
 * @author  Paul Slauenwhite
 * @version October 27, 2009
 * @since   February 1, 2005
 * @see     org.eclipse.ui.IFileEditorInput
 */
public class RCPFileEditorInput implements IPathEditorInput
{
	File file = null;
	IPath path = null;
	
	/**
	 * This constructor should not be used any longer because IFile is used for workspace file
	 * and this class is designed to support files outside the workspace. The arguement <i>iFile</i>
	 * will be ignored. Use {@link #RCPFileEditorInput(File)} instead.
	 * @see #RCPFileEditorInput(File)
	 * 
	 * @deprecated IFile will be ignored. Use {@link #RCPFileEditorInput(File)} instead.
	 */
	public RCPFileEditorInput(IFile iFile, File file) {
		
		//super(iFile);
		this.file = file;
		path = new Path(file.getAbsolutePath());
	}
	
	public RCPFileEditorInput(File file)
	{
		if(file == null)
			throw new IllegalArgumentException();
		this.file = file;
		path = new Path(file.getAbsolutePath());
	}

	public File getIOFile()
	{
		return file;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.ui.IPathEditorInput#getPath()
	 */
	public IPath getPath() {
		return path;
	}
	/* (non-Javadoc)
	 * @see org.eclipse.ui.IEditorInput#exists()
	 */
	public boolean exists() {
		return file.exists();
	}
	/* (non-Javadoc)
	 * @see org.eclipse.ui.IEditorInput#getImageDescriptor()
	 */
	public ImageDescriptor getImageDescriptor() {
		return PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(path.toString());
	}
	/* (non-Javadoc)
	 * @see org.eclipse.ui.IEditorInput#getName()
	 */
	public String getName() {
		return file.getName();
	}
	/* (non-Javadoc)
	 * @see org.eclipse.ui.IEditorInput#getPersistable()
	 */
	public IPersistableElement getPersistable() {
		return null;
	}
	/* (non-Javadoc)
	 * @see org.eclipse.ui.IEditorInput#getToolTipText()
	 */
	public String getToolTipText() {
		return file.getAbsolutePath();
	}
	/* (non-Javadoc)
	 * @see org.eclipse.core.runtime.IAdaptable#getAdapter(java.lang.Class)
	 */
	public Object getAdapter(Class adapter) {
		return null;
	}	
	
	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(Object object) {

		if ((object == this) || ((object instanceof RCPFileEditorInput) && (file.equals(((RCPFileEditorInput)(object)).getIOFile())))) {
			return true;
		}

		return false;
	}
}
