/*******************************************************************************
 * Copyright (c) 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: JavaTestLocationPage.java,v 1.1 2010/05/05 12:32:40 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.wizard;

import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.hyades.ui.util.LocationValidator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;

/**
 * <p>Extension of the {@link TestLocationPage} wizard location page for specifying Java
 * test files.</p>
 * 
 * 
 * @author  Paul E. Slauenwhite
 * @version May 4, 2010
 * @since   May 4, 2010
 * @see     TestLocationPage
 * @provisional As of TPTP V4.7.0, this is stable provisional API (see http://www.eclipse.org/tptp/home/documents/process/development/api_contract.html).
 */
public class JavaTestLocationPage extends TestLocationPage {
	
	public JavaTestLocationPage(String pageName, IStructuredSelection selection) {	      
		super(pageName, selection);
	}

	/**
	 * <p>Determines if the page's controls contain valid values.</p>
	 * 
	 * <p>Valid values require all of the following conditions (in order):</p>
	 * 
	 * <ol>
	 * <li>{@link TestLocationPage#validatePage(boolean)}</li>
	 * <li>The file path is valid:
	 * <ol>
	 * <li>{@link UIUtil#validateJavaFileName(String)}:
	 * <ol>
	 * <li>Does not start with a numeric value (0 - 9).</li>
	 * </ol>
	 * </li>
	 * </ol>
	 * </li>
	 * </ol>
	 * 
	 * <p>If the values are not valid, an error message is displayed if the page's message is to be 
	 * updated and the method returns false.</p>
	 * 
	 * @param updateMessage <code>true</code> if the page's message is to be updated, otherwise <code>false</code>.
	 * @return <code>true</code> if the page's controls contain valid values, otherwise <code>false</code>.
	 * @see TestLocationPage#validatePage(boolean)
	 */
	protected boolean validatePage(boolean updateMessage){
		
		//Case 1: Container and/or file name are missing or invalid:
		if(!super.validatePage(updateMessage)){
			return false;
		}

		//Case 2: File name is invalid:
		String invalidCharacter = UIUtil.validateJavaFileName(getFileName());

		if(invalidCharacter != null){

			if(updateMessage){

				setMessage(null);

				if (Character.isDigit(invalidCharacter.charAt(0))) {
					setErrorMessage(UiPluginResourceBundle.JavaTestLocationPage_INVALID_FILE_NUMERIC_ERROR_);
				} 
				else if (LocationValidator.INVALID_PATH.equals(invalidCharacter)) {
					setErrorMessage(UiPluginResourceBundle.JavaTestLocationPage_INVALID_FILE_ERROR_);
				} 
				else {
					setErrorMessage(NLS.bind(UiPluginResourceBundle.JavaTestLocationPage_INVALID_FILE_CHARS_ERROR_, invalidCharacter)); 
				}		        				
			}

			return false;
		}
		
		//Case 3 (default): Valid container and file name:
		if(updateMessage){

			setMessage(null);
			setErrorMessage(null);
		}
		
		return true;
	}   	
}