/*******************************************************************************
 * Copyright (c) 2006, 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id$
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.wizard;

import org.eclipse.core.resources.IFile;
import org.eclipse.hyades.models.common.configuration.CFGLocation;
import org.eclipse.hyades.models.common.configuration.CFGMachineConstraint;
import org.eclipse.hyades.models.common.util.ICommonConstants;
import org.eclipse.hyades.test.core.util.LocationUtil;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.internal.wizard.LocationHostNameWizardPage;
import org.eclipse.hyades.test.ui.util.TestUIUtil;
import org.eclipse.hyades.ui.internal.wizard.HyadesNewWizard;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.tptp.platform.common.ui.wizard.LocationPage;
import org.eclipse.ui.PartInitException;

/**
 * <p>Extension of the {@link HyadesNewWizard} wizard for creating locations.</p>
 * 
 * 
 * @author      Jerome Gout
 * @author      Peter Sun
 * @author      Bianca Xue Jiang
 * @author 	    Paul E. Slauenwhite
 * @author 		Jerome Bozier
 * @version 	May 4, 2010
 * @since       February 16, 2006
 */
public class LocationNewWizard extends HyadesNewWizard {
	
	private CFGMachineConstraint newLocation = null;
    private LocationHostNameWizardPage hostnamePage = null;
    private TestLocationPage testLocationPage = null;

	/**
	 * Constructor for LocationNewWizard.
     * <p>Subclasses would be be able to change the title and the icon of the wizard.
	 */
	public LocationNewWizard()
	{
		super();
		setWindowTitle(UiPluginResourceBundle.WIZ_LOCATION_TTL); 
		setDefaultPageImageDescriptor(TestUIImages.INSTANCE.getImageDescriptor(TestUIImages.IMG_WIZBAN_NEWLOCATION));

		IDialogSettings dialogSettings = UiPlugin.getInstance().getDialogSettings();
		IDialogSettings settings = dialogSettings.getSection("LocationNewWizard"); //$NON-NLS-1$
		if(settings == null)
			settings = dialogSettings.addNewSection("LocationNewWizard"); //$NON-NLS-1$
		setDialogSettings(settings);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.internal.wizard.HyadesNewWizard#getLocationPage()
	 */
	protected LocationPage getLocationPage() {
		
		if(testLocationPage == null){

			testLocationPage = new TestLocationPage("locationLocation", selection); //$NON-NLS-1$

			String fileExtension = getFileExtension();
			
			if (fileExtension != null) {
				
				testLocationPage.setFileExtension(fileExtension);
				testLocationPage.setFileName(""); //$NON-NLS-1$
			}
		}

		return testLocationPage;
	}
	
	/**
	 * Returns the type for the location created by this wizard.
	 * @return String the type for the location created by this wizard.
	 */
	protected String getType()
	{
		return TestUIExtension.GENERIC_LOCATION_TYPE;
	}
	
	/**
	 * @see org.eclipse.hyades.ui.internal.wizard.HyadesNewWizard#getFileExtension()
     * <p>This method is not intended to be overridden by subclasses.
	 */
	public String getFileExtension()
	{
		return ICommonConstants.LOCATION_FILE_EXTENSION;
	}

	/**
	 * @see org.eclipse.jface.wizard.IWizard#addPages()
     * <p>This method is not intended to be overridden by subclasses. 
     * Addition pages can be added using <code>addLocationDetailsPage()</code>.
     * 
	 */
	public void addPages()
	{
		getLocationPage().setTitle(UiPluginResourceBundle.WIZ_LOCATION_GEN_PG_TTL); 
		getLocationPage().setDescription(UiPluginResourceBundle.WIZ_LOCATION_GEN_PG_LOC_DSC); 
		addPage(getLocationPage());
		
		getAttributeWizardPage().setTitle(UiPluginResourceBundle.WIZ_LOCATION_GEN_PG_TTL); 
		getAttributeWizardPage().setDescription(UiPluginResourceBundle.WIZ_LOCATION_GEN_PG_ATT_DSC); 
		addPage(getAttributeWizardPage());

		addLocationDetailsPage();
	}
	
	/**
	 * Subclasses may overwrite this method to add detail pages after the first page.
	 */
	protected void addLocationDetailsPage() {
		addPage(hostnamePage = new LocationHostNameWizardPage());
	}
	
	/**
	 * @see org.eclipse.hyades.ui.test.internal.wizard.HyadesNewWizard#createObject(org.eclipse.core.resources.IFile)
	 */
	protected boolean createObject(IFile file)
	throws Exception
	{
		String hostname = hostnamePage.getHostname();
		LocationUtil.createNew(file, getLocationPage().getFileNameWithoutExtension(), getAttributeWizardPage().getItemDescription(), hostname);
		return true;
	}
		
	/**
	 * @see org.eclipse.hyades.ui.internal.wizard.HyadesNewWizard#openEditor(org.eclipse.core.resources.IFile)
     * <p>This method is not intended to be overridden by subclasses. 
	 */
	protected void openEditor(IFile file) 
	throws PartInitException
	{
		//Attempt to open the editor:
		TestUIUtil.openEditor(file, TestUIExtension.LOCATION_EDITOR_PART_ID);		
	}	

	public CFGLocation getNewLocation()
	{
		return this.newLocation;
	}
}
