/*******************************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestSuiteNewWizard.java,v 1.18 2010/05/05 12:32:40 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.wizard;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofileFactory;
import org.eclipse.hyades.models.common.testprofile.TPFBehavior;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.models.common.util.ICommonConstants;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.util.TestUIUtil;
import org.eclipse.hyades.ui.internal.wizard.HyadesNewWizard;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.tptp.platform.common.ui.wizard.LocationPage;
import org.eclipse.ui.PartInitException;

/**
 * <p>Extension of the {@link HyadesNewWizard} wizard for creating test suites.</p>
 * 
 * 
 * @author  Patrick Nedelic
 * @author  Tony Wang
 * @author  Paul E. Slauenwhite
 * @author  Jerome Bozier
 * @version May 4, 2010
 * @since   February 1, 2005
 * @deprecated Use {@link TestSuiteNewWizard2}.
 */
public class TestSuiteNewWizard extends HyadesNewWizard {

	private TestLocationPage testLocationPage = null;
	
	/**
	 * Constructor for TestSuiteNewWizard
	 */
	public TestSuiteNewWizard()
	{
		super();
		setWindowTitle(UiPluginResourceBundle.WIZ_TST_SUITE_TTL); 
		setDefaultPageImageDescriptor(TestUIImages.INSTANCE.getImageDescriptor(TestUIImages.IMG_WIZBAN_NEWTESTSUITE));

		IDialogSettings dialogSettings = UiPlugin.getInstance().getDialogSettings();
		IDialogSettings settings = dialogSettings.getSection("TestSuiteNewWizard"); //$NON-NLS-1$
		if(settings == null)
			settings = dialogSettings.addNewSection("TestSuiteNewWizard"); //$NON-NLS-1$
		setDialogSettings(settings);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.internal.wizard.HyadesNewWizard#getLocationPage()
	 */
	protected LocationPage getLocationPage() {
		
		if(testLocationPage == null){

			testLocationPage = new TestLocationPage("testLocation", selection); //$NON-NLS-1$

			String fileExtension = getFileExtension();
			
			if (fileExtension != null) {
				
				testLocationPage.setFileExtension(fileExtension);
				testLocationPage.setFileName(""); //$NON-NLS-1$
			}
		}

		return testLocationPage;
	}
	
	/**
	 * Returns the type for the test suite created by this wizard.
	 * @return String
	 */
	protected String getType()
	{
		return TestUIExtension.GENERIC_TEST_SUITE_TYPE;
	}
	
	/**
	 * @see org.eclipse.hyades.ui.internal.wizard.HyadesNewWizard#getFileExtension()
	 */
	protected String getFileExtension()
	{
		return ICommonConstants.TEST_SUITE_FILE_EXTENSION;
	}

	/**
	 * @see org.eclipse.jface.wizard.IWizard#addPages()
	 */
	public void addPages()
	{
		getLocationPage().setTitle(UiPluginResourceBundle.WIZ_TST_SUITE_GEN_PG_TTL); 
		getLocationPage().setDescription(UiPluginResourceBundle.WIZ_TST_SUITE_GEN_PG_LOC_DSC); 
		addPage(getLocationPage());
		
		getAttributeWizardPage().setTitle(UiPluginResourceBundle.WIZ_TST_SUITE_GEN_PG_TTL); 
		getAttributeWizardPage().setDescription(UiPluginResourceBundle.WIZ_TST_SUITE_GEN_PG_ATT_DSC); 
		addPage(getAttributeWizardPage());
	}
	
	/**
	 * @see org.eclipse.hyades.ui.test.internal.wizard.HyadesNewWizard#createObject(org.eclipse.core.resources.IFile)
	 */
	protected boolean createObject(IFile file)
	throws Exception
	{
		Resource resource = createResource(file);
		EObject testsuite = createEObject();
        resource.getContents().add(testsuite);
        initializeCustomAttributes(testsuite);
		EMFUtil.save(resource);
		return true;
	}
	
    /**
     * Clients can use this hook to initialize custom attributes of the newly created test suite.<br>
     * This method is called just before saving the test suite on the file system.
     * @param testsuite the new test suite created by the wizard.
     */
	protected void initializeCustomAttributes(EObject testsuite) {
        //- default implementation does nothing.
    }

    /**
	 * Creates the EObject setting the attributes based on the information
	 * the user has defined in this wizard's pages.
	 * @return a not null EObject
	 */
	protected EObject createEObject()
	{
		TPFTestSuite testSuite = Common_TestprofileFactory.eINSTANCE.createTPFTestSuite();
		testSuite.setType(getType());
		testSuite.setName(getLocationPage().getFileNameWithoutExtension());
		
		String description = getAttributeWizardPage().getItemDescription();
		if((description != null) && (description.trim().length() > 0))
			testSuite.setDescription(description);
			
		if(testSuite.getBehavior() == null)
		{
			TPFBehavior behavior = Common_TestprofileFactory.eINSTANCE.createTPFBehavior();
			testSuite.setBehavior(behavior);
		} 		
			
		return testSuite;
	}
	
	/**
	 * Creates the EMF resource in which the object is added to.
	 * @return a not null Resource
	 */
	protected Resource createResource(IFile file)
	{
		URI uri = URI.createPlatformResourceURI(file.getFullPath().toString(), false);
		Resource.Factory factory = EMFUtil.getResourceFactory(ICommonConstants.TEST_SUITE_FILE_EXTENSION);
		return factory.createResource(uri);
	}

		
	/**
	 * @see org.eclipse.hyades.ui.internal.wizard.HyadesNewWizard#openEditor(org.eclipse.core.resources.IFile)
	 */
	protected void openEditor(IFile file) 
	throws PartInitException
	{
		//Attempt to open the editor:
		TestUIUtil.openEditor(file, TestUIExtension.GENERIC_TEST_SUITE_EDITOR_PART_ID);		
	}	
}
