/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IRecorderWizard.java,v 1.1 2005/09/23 20:31:24 jnevicos Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.tptp.test.internal.recorder.ui.wizards;

import org.eclipse.hyades.execution.recorder.Recorder;

/**
 * Root class for all recorder wizards, both the Generic Recorder Facilty, and
 * the old standalone recorder framework (pre TPTP4.1)
 * @author jnevicos
 *
 */
public interface IRecorderWizard {

	/**
	 * Method used by extending classes to add additional IRecorderListeners
	 *
	 */
	public void registerListeners();

	public void runTestGen(Recorder recorder);
	
	public void saveSettings();
}
