/*******************************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: NewTestFromRecordingWizard.java,v 1.20 2010/03/25 16:09:40 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.tptp.test.internal.recorder.ui.wizards;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.execution.recorder.IRecorderListenerFullFeedback;
import org.eclipse.hyades.execution.recorder.Recorder;
import org.eclipse.hyades.execution.recorder.RecorderFactory;
import org.eclipse.hyades.internal.execution.recorder.ui.RecorderClientUI;
import org.eclipse.hyades.internal.execution.recorder.ui.views.RecorderControlView;
import org.eclipse.hyades.internal.execution.recorder.utilities.RecorderFileUtil;
import org.eclipse.hyades.test.core.internal.resources.TestCorePluginResourceBundle;
import org.eclipse.hyades.test.core.testgen.TestGeneratorFactory;
import org.eclipse.hyades.test.internal.testgen.ui.TestgenUIWrapper;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.ui.internal.wizard.HyadesWizard;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tptp.test.provisional.recorder.ui.wizards.DefaultRecWizardProvider;
import org.eclipse.tptp.test.provisional.recorder.ui.wizards.IGenericRecorderPage;
import org.eclipse.tptp.test.provisional.recorder.ui.wizards.IGenericRecorderWizard;
import org.eclipse.tptp.test.provisional.recorder.ui.wizards.IRecorderPageProvider;
import org.eclipse.tptp.test.provisional.recorder.ui.wizards.RecLocationWizardPage;

/**
 * <p>NewTestFromRecordingWizard.java.</p>
 * 
 * 
 * @author  Paul E. Slauenwhite
 * @author  Jeffery Nevicosi
 * @version March 25, 2010
 * @since   September 23, 2005
 */
public class NewTestFromRecordingWizard extends HyadesWizard implements IGenericRecorderWizard {

	protected NewRecordingWizardPage page1 = null;

	protected IGenericRecorderPage[] pages = new IGenericRecorderPage[0];
	
	/**
	 * @deprecated As of TPTP 4.5.0, access the current selection using {@link #getSelection()}.
	 */
	protected IPath initSelection;
	
	public NewTestFromRecordingWizard(){
		super();
	}
	
	/**
	 * This is not implemented downstream in 4.2, since it will break API.
	 * <p/>
	 * 
	 * @param initialSelection Initial selection.
	 * @deprecated As of TPTP 4.5.0, use {@link #NewTestFromRecordingWizard()} and access the current selection using {@link #getSelection()}.
	 */
	public NewTestFromRecordingWizard(IPath initialSelection)
	{
		super();
		
		initSelection = initialSelection;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.internal.wizard.HyadesWizard#createPageControls(org.eclipse.swt.widgets.Composite)
	 */
	public void createPageControls(Composite parent) {

		super.createPageControls(parent);	
		
		setWindowTitle(UiPluginResourceBundle.NewRecordingWizardPage_TITLE); 
		setDefaultPageImageDescriptor(ImageDescriptor.createFromURL(UiPlugin.getDefault().getBundle().getEntry("icons/full/wizban/gen_record_wiz.gif"))); //$NON-NLS-1$
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.internal.wizard.HyadesWizard#initPages()
	 */
	protected void initPages() {
		setForcePreviousAndNextButtons(true);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.wizard.Wizard#performFinish()
	 */
	public boolean performFinish() {
		
		String recorderID = page1.getSelectedRecorder();
		if (page1.isNewRecording())
		{
			IRecorderPageProvider wizardPages = (IRecorderPageProvider) RecorderFactory.getInstance().getWizardPageProvider(recorderID, false);
			if (wizardPages.doFinish())
				RecorderClientUI.launchRecorder(wizardPages.getRecorder(), this);
			else
				return false;
		}
		else
		{ //existing recording, launch testgen
			String recPath = getRecorderData(IRecorderPageProvider.WIZARD_KEY_RECORDING_PATH);
			if (RecorderFactory.getInstance().getRecorderFileExtension(getRecorderID()).equals("rec"))
			{ //special cases -- dual file
				recPath += "model";
			}
			
			String tgPath =getRecorderData(IRecorderPageProvider.WIZARD_KEY_TESTGEN_PATH);
			IFile tgFile = UiPlugin.getWorkspace().getRoot().getFile(new Path(tgPath));
			if (RecorderFileUtil.fileExists(tgFile))
			{
				boolean b = MessageDialog.openConfirm(UiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), UiPluginResourceBundle.DefaultRecWizardProvider_FILES_EXIST_TITLE,
						UiPluginResourceBundle.DefaultRecWizardProvider_TESTSUITE_EXISTS);
				if (!b)
					return false;
				RecorderFileUtil.deleteFile(tgFile);
				
			}
			TestgenUIWrapper wrapper = new TestgenUIWrapper(getRecorderData(IRecorderPageProvider.WIZARD_KEY_TESTGEN_ID),
					recPath, 
					tgPath);
			wrapper.launchGenerator();

			
		}

		saveSettings();
		return true;
	}

	public void addPages() {
		//page 1 - Create test from new recording / Create test from existing recording
		//       - Select recorder type
		addPage(page1 = new NewRecordingWizardPage(this));		

		//all other pages are created dynamically, based on the selections of this page.
		//we'll save them in a data structure & override getNextPage() to determine which is called next
	}

	public String getRecorderID()
	{
		return page1.getSelectedRecorder();
	}

	public IGenericRecorderPage[] getProvidedPages(String recorderID) {
		
		//Check factory for provided pages:
		IRecorderPageProvider provider = (IRecorderPageProvider) RecorderFactory.getInstance().getWizardPageProvider(recorderID, false);			
		
		if (provider == null){
			provider = new DefaultRecWizardProvider();
		}
		
		IGenericRecorderPage[] providerPages = provider.getWizardPages(this);

		//Add the recording location page as the first page if the user gestured to use an existing recording:
		if (!page1.isNewRecording()){	

			String recExtension = RecorderFactory.getInstance().getRecorderFileExtension(recorderID);
			
			if (recExtension == null){
				recExtension = "recmodel"; //$NON-NLS-1$
			}
			
			IGenericRecorderPage[] allPages = new IGenericRecorderPage[providerPages.length + 1];
			allPages[0] = new RecLocationWizardPage(this,recExtension, true);

			System.arraycopy(providerPages, 0, allPages, 1, providerPages.length);
			
			return allPages;
		}
		
		return providerPages;
	}

	public void notifyRecorderChanged() {		
		pages = getProvidedPages(page1.getSelectedRecorder());		
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.wizard.Wizard#getNextPage(org.eclipse.jface.wizard.IWizardPage)
	 */
	public IWizardPage getNextPage(IWizardPage page) {
		
		if (pages.length > 0){
			
			if (page == page1){
				return pages[0];
			}
			
			for (int i = 0; i < pages.length; i++){
				
				if ((page == pages[i]) && (pages.length > (i+1))){
					return pages[i+1];
				}
			}
		}
		
		return super.getNextPage(page);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.test.internal.recorder.ui.wizards.IRecorderWizard#registerListeners()
	 */
	public void registerListeners() {
		//No-operation.
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.test.internal.recorder.ui.wizards.IRecorderWizard#runTestGen(org.eclipse.hyades.execution.recorder.Recorder)
	 */
	public void runTestGen(Recorder recorder) {
		
		String scriptGenID = recorder.getScriptgenID();
		
		if (scriptGenID == null || scriptGenID.equals("-1")){ //$NON-NLS-1$
			return;
		}
		
		String scriptGenName = TestGeneratorFactory.getInstance().getGeneratorName(scriptGenID);
		String recordingPath = recorder.getRecordingPath();
		RecorderFactory.getInstance().controlMessage(recorder, IRecorderListenerFullFeedback.VIEW_MESSAGE,
				TestCorePluginResourceBundle.RecorderClient_Test_generation_started_with_generator___4 + " " + scriptGenName); 
			
		IFile traceFile;
		
		if(recordingPath.endsWith(".rec")) //$NON-NLS-1$
		{
			traceFile = ResourcesPlugin.getWorkspace().getRoot().getFile(new Path(recordingPath+"model")); //$NON-NLS-1$
		}
		else
		{
			traceFile = ResourcesPlugin.getWorkspace().getRoot().getFile(new Path(recordingPath));
		}
						
		if(traceFile.exists())
		{
			RecorderFactory.getInstance().controlMessage(recorder, IRecorderListenerFullFeedback.VIEW_MESSAGE,
				TestCorePluginResourceBundle.RecorderClient_TEST_TO_BE_GENERATED + " " + recorder.getTestPath()); 
			TestgenUIWrapper wrapper = new TestgenUIWrapper(scriptGenID, traceFile, recorder.getTestPath());
			wrapper.addListener(RecorderControlView.getInstance());
			wrapper.launchGenerator();
			//testgen success notify message is handled from the recorderControlView
		}
		else
		{
			RecorderFactory.getInstance().controlMessage(recorder, IRecorderListenerFullFeedback.VIEW_MESSAGE,
					TestCorePluginResourceBundle.RecorderClient_UNABLE_TO_GENERATE_NO_TRACE_FILE); 
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.test.internal.recorder.ui.wizards.IRecorderWizard#saveSettings()
	 */
	public void saveSettings() {
		
		page1.saveSettings();
		
		for (int i = 0; i < pages.length; i++){
			pages[i].saveSettings();
		}
		
	}
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.test.internal.recorder.ui.wizards.IGenericRecorderWizard#getRecorderData(java.lang.String)
	 */
	public String getRecorderData(String key) {
		
		if (page1 == null){
			return null;
		}
		
		if (page1.getRecorderData(key)!= null){
			return page1.getRecorderData(key);
		}
		
		for (int i = 0; i < pages.length; i++){
			
			if (pages[i].getRecorderData(key) != null){
				return pages[i].getRecorderData(key);
			}
		}
		
		//do default behavior if not found
		if (key.equals(IRecorderPageProvider.WIZARD_KEY_RECORDING_PATH) && page1.isNewRecording())
		{
			String testSuite = getRecorderData(IRecorderPageProvider.WIZARD_KEY_TESTGEN_PATH);
			
			if ((testSuite != null) && (testSuite.endsWith(".testsuite"))) //$NON-NLS-1$
			{
				String rec = testSuite.substring(0,testSuite.lastIndexOf(".testsuite")); //$NON-NLS-1$
				String fileExt = RecorderFactory.getInstance().getRecorderFileExtension(getRecorderID());
				rec += "."  + fileExt; //$NON-NLS-1$
				return rec;
			}
		}
		
		return null;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.test.internal.recorder.ui.wizards.IGenericRecorderWizard#getRecorderObjectData(java.lang.String)
	 */
	public Object getRecorderObjectData(String key) {
		
		if(key.equals(IRecorderPageProvider.WIZARD_KEY_INITIAL_STRUCTURED_SELECTION)){
			return selection;
		}
		
		if (page1 == null){
			return null;
		}
		
		if (page1.getRecorderObjectData(key)!= null){
			return page1.getRecorderObjectData(key);
		}
		
		for (int i = 0; i < pages.length; i++){
			
			if (pages[i].getRecorderObjectData(key) != null){
				return pages[i].getRecorderObjectData(key);
			}
		}
		
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.wizard.Wizard#canFinish()
	 */
	public boolean canFinish() {
		
		//the internal Wizard registry of pages is invalid
		if (!page1.isPageComplete()){
			return false;
		}
		
		if (pages == null){		
			return super.canFinish();
		}
		
		for (int i=0; i < pages.length; i++){
			
			if (!pages[i].isPageComplete()){
				return false;
			}
		}
		
		return true;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.wizard.Wizard#performCancel()
	 */
	public boolean performCancel() {
		
		String recID = page1.getSelectedRecorder();
		IRecorderPageProvider provider = (IRecorderPageProvider) RecorderFactory.getInstance().getWizardPageProvider(recID, false);			
		
		if (provider == null) {
			return super.performCancel();
		}
		else {
			return provider.doCancel();
		}
	}
}
