/*******************************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AbstractRecorderMessageProvider.java,v 1.6 2008/04/10 11:01:49 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.tptp.test.provisional.recorder.messages;

import org.eclipse.hyades.execution.recorder.Recorder;
import org.eclipse.hyades.execution.recorder.RecorderFactory;
import org.eclipse.hyades.internal.execution.recorder.remote.IRecorderMessageTypes;
import org.eclipse.hyades.internal.execution.recorder.ui.views.RecorderControlView;
import org.eclipse.tptp.test.provisional.recorder.framework.IRecorderMessageProvider;

/**
 * An abstract implementation of IRecorderMessageProvider.
 * <p/>
 * 
 * 
 * @author  Paul E. Slauenwhite
 * @author  Jeffery Nevicosi
 * @version April 10, 2008
 * @since   February 1, 2006
 */
public abstract class AbstractRecorderMessageProvider implements
		IRecorderMessageProvider {

	protected Recorder recorder;
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.test.provisional.recorder.framework.IRecorderClientHelper#getRecorder()
	 */
	public Recorder getRecorder() {
		return recorder;
	}
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.test.provisional.recorder.framework.IRecorderProvider#getRecorderID()
	 */
	public String getRecorderID() {
		return recorder.getId();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.test.provisional.recorder.framework.IRecorderProvider#setRecorderID(java.lang.String)
	 */
	public void setRecorder(String id) {
		recorder = RecorderFactory.getInstance().getRecorderWithID(id);
		
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.test.provisional.recorder.framework.IRecorderProvider#setRecorder(org.eclipse.hyades.execution.recorder.Recorder)
	 */
	public void setRecorder(Recorder recorder) {
		this.recorder = recorder;		
	}
	
	/**
	 * This method is called if processMessage(String) did not determine that the message
	 * was one of its default types.  
	 * @param str
	 * @return true if message is handled.
	 */
	protected boolean processCustomMessage(String str)
	{
		return false;
	}

	/**
	 * Called when processing a IRecorderMessageTypes.MESSAGE_UI_TRANSLATE message.
	 * It is up to the extending provider to implement this.
	 * 
	 *  If your RecorderAgent does not plan on sending this message, then just return "".
	 * @param str
	 */
	protected abstract String translateString(String str);
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.test.provisional.recorder.framework.IRecorderMessageProvider#processMessage(java.lang.String)
	 */
	public boolean processMessage(String str) {
		
		
		//check default messages first
		String strHeader, strData;
		if (str.indexOf(' ') > 0)
		{
			strHeader = str.substring(0, str.indexOf(' '));
			strData = str.substring(str.indexOf(' '));
		}
		else
		{
			strHeader = str;
			strData = "";
		}
		
		if (strHeader.equals(IRecorderMessageTypes.MESSAGE_UI_RAW))
		{
			//send the data to the Control View
			RecorderControlView.getInstance().addMessage(strData);
			return true;
		}
		if (strHeader.equals(IRecorderMessageTypes.MESSAGE_UI_TRANSLATE))
		{
			RecorderControlView.getInstance().addMessage(translateString(strData));
			return true;
		}
		boolean b = processCustomMessage(str);
		
		if (!b)
		{
			//TODO: log unhandled message
		}
		return b;
	}
	
}
