/*******************************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DefaultRecorderClientHelper.java,v 1.3 2006/05/31 21:26:21 jnevicos Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.tptp.test.provisional.recorder.ui.framework;

import org.eclipse.hyades.execution.recorder.Recorder;
import org.eclipse.hyades.execution.recorder.RecorderFactory;
import org.eclipse.tptp.test.provisional.recorder.framework.IRecorderClientHelper;
import org.eclipse.tptp.test.provisional.recorder.framework.RecorderClientHelperAdapter;
import org.eclipse.tptp.test.provisional.recorder.ui.wizards.IRecorderPageProvider;

/**
 * A default implementation of a IRecorderClientHelper.  This will populate
 * some necessary Recorder attributes by querying the WizardPageProvider.
 * @author jnevicos
 */
public class DefaultRecorderClientHelper extends RecorderClientHelperAdapter
		implements IRecorderClientHelper {

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.test.provisional.recorder.framework.RecorderClientHelperAdapter#preSetup()
	 */
	public boolean preSetup() {
		IRecorderPageProvider wizardProv = (IRecorderPageProvider) RecorderFactory.getInstance().getWizardPageProvider(getRecorderID(), false);
		
		//load Recorder data from wizard provider.
		Recorder rec = getRecorder();
		if (wizardProv == null || rec == null)
			return false;
		rec.setRecordingPath(wizardProv.getValue(IRecorderPageProvider.WIZARD_KEY_RECORDING_PATH));
		rec.setTestPath(wizardProv.getValue(IRecorderPageProvider.WIZARD_KEY_TESTGEN_PATH));
		rec.setConfigParams(wizardProv.getValue(IRecorderPageProvider.WIZARD_KEY_CONFIG_PARAMS));
		rec.setApplicationAdapterID(wizardProv.getValue(IRecorderPageProvider.WIZARD_KEY_APP_ADAPTER));
		rec.setScriptgenID(wizardProv.getValue(IRecorderPageProvider.WIZARD_KEY_TESTGEN_ID));
		return true;
	}

}
