/********************************************************************** 
 * Copyright (c) 2006, 2010 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 *  
 * 
 * Contributors: 
 *      pnedelec (IBM) - Initial API and implementation 
 **********************************************************************/
package org.eclipse.tptp.test.provisional.recorder.ui.wizards;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.window.Window;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tptp.test.provisional.recorder.ProvisionalRecorderMessages;
import org.eclipse.ui.wizards.newresource.BasicNewFolderResourceWizard;

/**
 * <p>Extension of the {@link TestsuiteLocationWizardPage} wizard for creating test suites from a recording.</p>
 * 
 *  
 * @author  Patrick Nedelec
 * @author  Paul Slauenwhite
 * @version May 4, 2010
 * @since   August 23, 2006
 * @deprecated As of TPTP V4.7.0, use {@link TestsuiteLocationWizardPage}.
 */
public abstract class CTestsuiteLocationWizardPage extends TestsuiteLocationWizardPage {

    public CTestsuiteLocationWizardPage(IGenericRecorderWizard wizard) {
        super(wizard);
    }

    public CTestsuiteLocationWizardPage(IGenericRecorderWizard wizard, boolean bSaveLastSelected) {
        super(wizard, bSaveLastSelected);
    }

    /** 
     * @see org.eclipse.hyades.internal.execution.testgen.ui.wizards.FileLocationSelectionWizardpage#createControl(org.eclipse.swt.widgets.Composite)
     */
    public void createControl(Composite grandParent) {
        super.createControl(grandParent);
        Composite parent = null;
        try {
            parent = tree.getTree().getParent();
        } catch (RuntimeException e1) {
            return;
        }
        if (parent == null) return;
        Layout layout = parent.getLayout();
        if (layout instanceof GridLayout) {
            ((GridLayout) layout).numColumns = 2;
            ((GridLayout) layout).makeColumnsEqualWidth = false;
        }

        Composite btnGroup = new Composite(parent, SWT.NULL);
        GridLayout gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        btnGroup.setLayout(gl);
        btnGroup.setLayoutData(new GridData(GridData.GRAB_VERTICAL | GridData.VERTICAL_ALIGN_BEGINNING));
        btnGroup.moveBelow(getViewer().getTree());

        Button newProjectBtn = new Button(btnGroup, SWT.PUSH);
        newProjectBtn.setText(ProvisionalRecorderMessages.Button_NEW_PROJECT);
        newProjectBtn.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        newProjectBtn.setEnabled(true);

        final Button newFolderBtn = new Button(btnGroup, SWT.PUSH);
        newFolderBtn.setText(ProvisionalRecorderMessages.Button_NEW_FOLDER); 
        newFolderBtn.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        newFolderBtn.setEnabled(false);

        getViewer().addSelectionChangedListener(new ISelectionChangedListener() {
            public void selectionChanged(SelectionChangedEvent event) {
                IContainer container = getSelectedContainer();
                newFolderBtn.setEnabled(container != null);
            }

        });

        newProjectBtn.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent e) {
                IProject newProject = createNewProject();
                if (newProject != null) {
                    getViewer().refresh();
                    getViewer().setSelection(new StructuredSelection(newProject), true);
                    getViewer().getTree().setFocus();
                }
            }
        });

        newFolderBtn.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent e) {
                IContainer container = getSelectedContainer();
                if (container == null) return;
                NewFolderWizard wizard = new NewFolderWizard();
                wizard.init(UiPlugin.getDefault().getWorkbench(), new StructuredSelection(container));
                WizardDialog wizardDialog = new WizardDialog(Display.getCurrent().getActiveShell(), wizard);
                wizardDialog.create();
                if (wizardDialog.open() != Window.OK) {
                    return;
                }
                if (wizard.getNewResource() != null) {
                    getViewer().refresh();
                    getViewer().setSelection(new StructuredSelection(wizard.getNewResource()), true);
                    getViewer().getTree().setFocus();
                }
            }

        });
    }

    /**
     * Override this method to control the project creation on the wizard page.
     * @return the created project that will be selected in the tree.
     */
    abstract protected IProject createNewProject();

    /**
     * 
     * @return the tree viewer that allow to select the container
     */
    protected TreeViewer getViewer() {
        return tree;
    }

    /**
     * 
     * @return the selected resource that will contain the recorded test
     */
    protected IContainer getSelectedContainer() {
        if (tree == null) return null;
        ISelection selection = tree.getSelection();
        if (selection == null || selection.isEmpty() || !(selection instanceof StructuredSelection)) return null;
        Object obj = ((StructuredSelection) selection).getFirstElement();
        if (obj instanceof IContainer) return (IContainer) obj;
        return null;
    }

    /**
     * This wizard creates a folder and can return it. 
     */
    protected class NewFolderWizard extends BasicNewFolderResourceWizard {
        private IResource newFolder = null;

        protected void selectAndReveal(IResource newResource) {
            newFolder = newResource;
            super.selectAndReveal(newResource);
        }

        public IResource getNewResource() {
            return newFolder;
        }
    }

}
