/*******************************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DefaultRecWizardProvider.java,v 1.10 2010/03/25 16:09:41 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.tptp.test.provisional.recorder.ui.wizards;

import java.util.HashMap;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.execution.recorder.Recorder;
import org.eclipse.hyades.execution.recorder.RecorderFactory;
import org.eclipse.hyades.internal.execution.recorder.utilities.RecorderFileUtil;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.jface.dialogs.MessageDialog;

/**
 * <p>Default recording wizard provider that provides an additional page ({@link TestsuiteLocationWizardPage})
 * to enter the path/name of the test suite, which is used to derive the recording and recording model file 
 * paths/names.</p>
 * 
 * 
 * @author  Jeffrey Nevicosi
 * @author  Paul Slauenwhite
 * @version March 25, 2010
 * @since   February 1, 2006
 * @see     IRecorderPageProvider
 * @see     TestsuiteLocationWizardPage
 * @see     IGenericRecorderPage
 */
public class DefaultRecWizardProvider implements IRecorderPageProvider {

	protected Recorder recorder = null;
	protected HashMap dataMap = new HashMap();
	private IGenericRecorderPage[] pages = null;
	private IGenericRecorderWizard wizard = null;
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.test.provisional.recorder.ui.wizards.IRecorderPageProvider#getWizardPages()
	 */
	public IGenericRecorderPage[] getWizardPages(IGenericRecorderWizard wizard) {		
		pages = new IGenericRecorderPage[1];
		pages[0] = new TestsuiteLocationWizardPage(wizard);
		this.wizard = wizard; 
		return pages;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.test.provisional.recorder.ui.wizards.IRecorderPageProvider#getValue(java.lang.String)
	 */
	public String getValue(String key) {
		if (dataMap.get(key) == null)
			return null;
		return dataMap.get(key).toString();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.test.provisional.recorder.ui.wizards.IRecorderPageProvider#getObjectValue(java.lang.String)
	 */
	public Object getObjectValue(String key) {	
		return dataMap.get(key);
	}

	
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.test.provisional.recorder.ui.wizards.IRecorderPageProvider#doFinish()
	 */
	public boolean doFinish() {
		//debugging
		
		dataMap.put(WIZARD_KEY_RECORDING_PATH, wizard.getRecorderData(WIZARD_KEY_RECORDING_PATH));
		dataMap.put(WIZARD_KEY_TESTGEN_PATH, wizard.getRecorderData(WIZARD_KEY_TESTGEN_PATH));

		//check for existance of rec file / testgen file
		String recPath = dataMap.get(WIZARD_KEY_RECORDING_PATH).toString();
		IFile recFile = UiPlugin.getWorkspace().getRoot().getFile(new Path(recPath));		
		boolean bRecExists = RecorderFileUtil.fileExists(recFile);
		//IFile.exists() must be case insensitive for Windows, or else the create will fail later
		String tgPath = dataMap.get(WIZARD_KEY_TESTGEN_PATH).toString();
		IFile tgFile = UiPlugin.getWorkspace().getRoot().getFile(new Path(tgPath));
		boolean bTestExists = RecorderFileUtil.fileExists(tgFile);
		
		if (bRecExists && bTestExists)
		{
			boolean b = MessageDialog.openConfirm(UiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), UiPluginResourceBundle.DefaultRecWizardProvider_FILES_EXIST_TITLE,
					UiPluginResourceBundle.DefaultRecWizardProvider_BOTH_EXIST);
			if (!b)
				return false;

			RecorderFileUtil.deleteRecordingFile(recFile);
			RecorderFileUtil.deleteFile(tgFile);
			
		}
		else if (bRecExists)
		{
			boolean b = MessageDialog.openConfirm(UiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), UiPluginResourceBundle.DefaultRecWizardProvider_FILES_EXIST_TITLE,
					UiPluginResourceBundle.DefaultRecWizardProvider_REC_EXISTS);
			if (!b)
				return false;
			RecorderFileUtil.deleteRecordingFile(recFile);

		}
		else if (bTestExists)
		{
			boolean b = MessageDialog.openConfirm(UiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), UiPluginResourceBundle.DefaultRecWizardProvider_FILES_EXIST_TITLE,
					UiPluginResourceBundle.DefaultRecWizardProvider_TESTSUITE_EXISTS);
			if (!b)
				return false;
			RecorderFileUtil.deleteFile(tgFile);
		}
		
		String parms = wizard.getRecorderData(WIZARD_KEY_CONFIG_PARAMS);
		String appID = wizard.getRecorderData(WIZARD_KEY_APP_ADAPTER);
		String tgID = wizard.getRecorderData(WIZARD_KEY_TESTGEN_ID);
		
		dataMap.put(WIZARD_KEY_CONFIG_PARAMS, parms==null?"":parms);
		dataMap.put(WIZARD_KEY_APP_ADAPTER, appID==null?"-1":appID);
		dataMap.put(WIZARD_KEY_TESTGEN_ID , tgID==null?"-1":tgID);
		return true;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.test.provisional.recorder.ui.wizards.IRecorderPageProvider#doCancel()
	 */
	public boolean doCancel() {
		// TODO Auto-generated method stub
		return true;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.test.provisional.recorder.framework.IRecorderClientHelper#getRecorder()
	 */
	public Recorder getRecorder() {
		return recorder;
	}
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.test.provisional.recorder.framework.IRecorderProvider#getRecorderID()
	 */
	public String getRecorderID() {
		return recorder.getId();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.test.provisional.recorder.framework.IRecorderProvider#setRecorderID(java.lang.String)
	 */
	public void setRecorder(String id) {
		recorder = RecorderFactory.getInstance().getRecorderWithID(id);		
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.test.provisional.recorder.framework.IRecorderProvider#setRecorder(org.eclipse.hyades.execution.recorder.Recorder)
	 */
	public void setRecorder(Recorder recorder) {
		this.recorder = recorder;		
	}
	
	public IGenericRecorderWizard getWizard() {
		return wizard;
	}
	
}
