/*******************************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IGenericRecorderPage.java,v 1.3 2006/05/31 21:26:20 jnevicos Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.tptp.test.provisional.recorder.ui.wizards;

import org.eclipse.jface.wizard.IWizardPage;

/**
 * All wizard pages provided with the IRecorderPageProvider, must
 * extend this class.
 * 
 * @author jnevicos
 */
public interface IGenericRecorderPage extends IWizardPage {

	/**
	 * Mechanism for the recorder page provider to obtain information from the recorder pages.
	 * @param key - some unique identifier, like those listed in IRecorderPageProvider
	 * @return a String with value for that key, or null if no data exists
	 */
	public String getRecorderData(String key);

	/**
	 * Mechanism for the recorder page provider to obtain information from the recorder pages.
	 * @param key - some unique identifier, like those listed in IRecorderPageProvider
	 * @return an Object with value for that key, or null if no data exists
	 */
	public Object getRecorderObjectData(String key);
	
	/**
	 * Saves user settings to be loaded the next time the page is created.
	 */
	public void saveSettings();

}
