/*******************************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IGenericRecorderWizard.java,v 1.1 2006/02/15 18:15:58 jnevicos Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.tptp.test.provisional.recorder.ui.wizards;

import org.eclipse.tptp.test.internal.recorder.ui.wizards.IRecorderWizard;
import org.eclipse.ui.INewWizard;

/**
 * An interface for extending the main wizard for the generic recorder facility.
 * 
 * @author jnevicos
 *
 */
public interface IGenericRecorderWizard extends INewWizard, IRecorderWizard {

	/**
	 * gets selected recorder ID (in the generic wizard, selected on the first page)
	 * @return recorderID
	 */
	public String getRecorderID();

	
	/**
	 * All additional pages are provided through the extension point (TODO), this
	 * method finds 
	 * @param recorderID
	 * @return
	 */
	public IGenericRecorderPage[] getProvidedPages(String recorderID);
	
	/**
	 * Method called from wizard pages to notify the wizard that the selected recorder has changed.
	 * Signals the recorder to load the new pages from the recorder's page provider.
	 *
	 */
	public void notifyRecorderChanged();
	
	/**
	 * Mechanism for the recorder page provider to obtain information from the recorder pages.
	 * The wizard will in turn call getRecorderData(String) for all of its pages until it gets valid data
	 * @param key - some unique identifier, like those listed in IRecorderPageProvider
	 * @return a String with value for that key, or null if no data exists
	 */
	public String getRecorderData(String key);

	/**
	 * Mechanism for the recorder page provider to obtain information from the recorder pages.
	 * The wizard will in turn call getRecorderObjectData(String) for all of its pages until it gets valid data
	 * @param key - some unique identifier, like those listed in IRecorderPageProvider
	 * @return an Object with value for that key, or null if no data exists
	 */
	public Object getRecorderObjectData(String key);
}
