/*******************************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IRecorderPageProvider.java,v 1.8 2008/11/25 18:32:00 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.tptp.test.provisional.recorder.ui.wizards;

import org.eclipse.hyades.execution.recorder.local.appadapters.IRecorderApplicationAdapter;
import org.eclipse.hyades.test.core.testgen.TestGenerator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.tptp.test.provisional.recorder.framework.IRecorderClientHelper;
import org.eclipse.tptp.test.provisional.recorder.framework.IRecorderProvider;

/**
 * <p>A recorder provider which provides additional custom wizard pages to the generic
 * recording wizard.</p>
 * 
 * 
 * <p>This provider is responsible for assembling the pages, collecting the page data,
 * and providing a mechanism to provide this data to other providers.</p>
 * 
 * <p>Implementations are responsible for configuring the associated recorder 
 * application (see {@link IRecorderApplicationAdapter}) during initialization.  For example:</p>
 * 
 * <p><code>RecorderAppAdapterFactory.getInstance().getAppAdapter(&lt;recorder application ID&gt;).setInitString(&lt;initialization string&gt;);</code></p>
 * 
 * <p>If the associated recorder application is not configured in the {@link IRecorderClientHelper#preSetup()} method, 
 * it should be configured in the {@link #doFinish()} method.</p>
 *  
 * 
 * @author  Paul E. Slauenwhite
 * @author  Jeffery Nevicosi
 * @version November 25, 2008
 * @since   February 1, 2006
 */
public interface IRecorderPageProvider extends IRecorderProvider {

	/**
	 * The default key string for defining the initial {@link IStructuredSelection} provided by the {@link IGenericRecorderWizard}.
	 * <p/>
	 * The {@link IGenericRecorderPage} pages provided by this {@link IRecorderPageProvider} can 
	 * retrive the initial {@link IStructuredSelection} from the {@link IGenericRecorderWizard} by
	 * calling {@link IGenericRecorderWizard#getRecorderObjectData(IRecorderPageProvider.WIZARD_KEY_INITIAL_STRUCTURED_SELECTION)}, 
	 * if the {@link IGenericRecorderWizard} provides an initial {@link IStructuredSelection}.
	 */
	public static final String WIZARD_KEY_INITIAL_STRUCTURED_SELECTION = "keyWizardStructuredSelection";

	/**
	 * default key string for defining path to a recording file
	 */
	public static final String WIZARD_KEY_RECORDING_PATH = "keyWizardPath";
	
	/**
	 * default key string for defining path to the test to be generated
	 */
	public static final String WIZARD_KEY_TESTGEN_PATH = "keyTestgenPath";
	
	/**
	 * default key string for the recording instance's init and config paramaters (String)
	 */
	public static final String WIZARD_KEY_CONFIG_PARAMS = "keyConfigParams";
	
	/**
	 * default key string for the recording instance's Application Adapter id
	 * @see  RecorderAppAdapter (schema)
	 */
	public static final String WIZARD_KEY_APP_ADAPTER = "keyAppAdapter";
	
	/**
	 * default key string the defining the test generator's ID, or "-1" if none.
	 * @see  TestGenerator (schema)
	 * @see org.eclipse.hyades.test.core.testgen.TestGenerator
	 */
	public static final String WIZARD_KEY_TESTGEN_ID = "keyTestgenID";
	
	/**
	 * Called by generic recorder wizard, provides additional recorder wizard pages
	 * @return IGenericRecorderPage[]
	 */
	public IGenericRecorderPage[] getWizardPages(IGenericRecorderWizard wizard);
	
	/**
	 * Returns a value from the wizard providers internal storage facility.  Used by recorder framework
	 * to access key data set in the wizard. 
	 * @param key
	 * @return String associated with the key value <pre>key</pre> or <pre>null</pre> if no data.
	 */
	public String getValue(String key);
	
	/**
	 * Returns an Object value from the wizard providers internal storage facility.  Used by recorder framework
	 * to access key data set in the wizard. 
	 * @param key
	 * @return Object associated with the key value <pre>key</pre> or <pre>null</pre> if no data.
	 */
	public Object getObjectValue(String key);
	
	/**
	 * Called if wizard Finish button is pressed.  Note that initializing for recording is not intended
	 * to begin here, but in IRecorderClientHelper.preSetup()
	 * @return true if no errors
	 */
	public boolean doFinish();
	
	/**
	 * Called if wizard Cancel button is pressed.
	 * @return true if no errors
	 */
	public boolean doCancel();
	
	/**
	 * Returns the containing wizard.  This should be the wizard that is 
	 * a parameter in the constructor IRecorderPageProvider(IGenericRecorderWizard)
	 * @return
	 */
	public IGenericRecorderWizard getWizard();

}
