/*******************************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: RecLocationWizardPage.java,v 1.14 2010/05/05 12:32:45 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.tptp.test.provisional.recorder.ui.wizards;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.internal.execution.testgen.ui.wizards.FileLocationSelectionWizardpage;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.internal.util.ContextIds;
import org.eclipse.hyades.test.ui.wizard.TestLocationPage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Image;

/**
 * <p>Extension of the {@link FileLocationSelectionWizardpage} wizard for creating recordings.</p>
 *
 *
 * @author  Jeffrey Nevicosi
 * @author  Paul E. Slauenwhite
 * @version May 4, 2010
 * @since   February 1, 2006
 * @see     FileLocationSelectionWizardpage
 * @see     IGenericRecorderPage
 */
public class RecLocationWizardPage extends FileLocationSelectionWizardpage implements IGenericRecorderPage {

	private String fileExtension;

	/**
	 * 
	 * @param wizard - the container IGenericRecorderWizard
	 * @param extension - file extension for recording file (e.g. "rec" or "recmodel")
	 */
	public RecLocationWizardPage(IGenericRecorderWizard wizard, String extension)
	{
		this(wizard, extension, true);
	}

	/**
	 * 
	 * @param wizard - the container IGenericRecorderWizard
	 * @param extension - file extension for recording file (e.g. "rec" or "recmodel")
	 * @param bSaveLastSelected - when page is initially loaded, should the previous selection by preselected?
	 *
	 */
	public RecLocationWizardPage(IGenericRecorderWizard wizard, String extension, boolean bSaveLastSelected)
	{
		//Note: This wizard page may be instantiated without a wizard since the wizard can be set using org.eclipse.jface.wizard.WizardPage.setWizard(IWizard).
		super(bSaveLastSelected, (wizard != null ? ((IStructuredSelection)(wizard.getRecorderObjectData(IRecorderPageProvider.WIZARD_KEY_INITIAL_STRUCTURED_SELECTION))) : null));	
		fileExtension = extension;
		setWizard(wizard);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.internal.execution.testgen.ui.wizards.FileLocationSelectionWizardpage#getDescription()
	 */
	public String getDescription() {
		return UiPluginResourceBundle.RecLocationWizardPage_DESCRIPTION;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.internal.execution.testgen.ui.wizards.FileLocationSelectionWizardpage#getFileExtension()
	 */
	public String getFileExtension() {
		return fileExtension;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.internal.execution.testgen.ui.wizards.FileLocationSelectionWizardpage#getTitle()
	 */
	public String getTitle() {
		return UiPluginResourceBundle.NewRecordingWizardPage_TITLE;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.internal.execution.testgen.ui.wizards.ITestGenWizardPage#getContextHelpID()
	 */
	public String getContextHelpID() {		
		return (UiPlugin.getID() + ContextIds.NEW_TEST_FROM_RECORDING_WIZARD);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.test.provisional.recorder.ui.wizards.IGenericRecorderPage#getRecorderData(java.lang.String)
	 */
	public String getRecorderData(String key) {
		if (key.equals(IRecorderPageProvider.WIZARD_KEY_RECORDING_PATH))
			return getFilePath();
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.test.provisional.recorder.ui.wizards.IGenericRecorderPage#getRecorderObjectData(java.lang.String)
	 */
	public Object getRecorderObjectData(String key) {
		// TODO Auto-generated method stub
		return null;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.internal.execution.testgen.ui.wizards.FileLocationSelectionWizardpage#getObjectImage(java.lang.Object)
	 */
	protected Image getObjectImage(Object element) {
		
		if (element instanceof IFile)
		{ //just filtering on IFile is enough, since the getFileExtension()
			//ensures that we'll only be displaying one type of file.
            return TestUIImages.INSTANCE.getImage(TestUIImages.IMG_GEN_RECORD);
        }
		return null;
	}
	
	/**
	 * <p>Determines if the page's controls contain valid values.</p>
	 * 
	 * <p>Valid values require all of the following conditions (in order):</p>
	 * 
	 * <ol>
	 * <li>{@link TestLocationPage#validatePage(boolean)}</li>
	 * <li>The file exists in the workspace.</li>
	 * </ol>
	 * 
	 * <p>If the values are not valid, an error message is displayed if the page's message is to be 
	 * updated and the method returns false.</p>
	 * 
	 * @param updateMessage <code>true</code> if the page's message is to be updated, otherwise <code>false</code>.
	 * @return <code>true</code> if the page's controls contain valid values, otherwise <code>false</code>.
	 * @see TestLocationPage#validatePage(boolean)
	 */
	protected boolean validatePage(boolean updateMessage){
	
		//Case 1: Container and/or file name are missing or invalid:
		if(!super.validatePage(updateMessage)){
			return false;
		}
		
		//Case 2: File does not exist:
		if(!ResourcesPlugin.getWorkspace().getRoot().getFile(new Path(getFilePath())).exists()){

			if(updateMessage){

				setMessage(null);
				setErrorMessage(UiPluginResourceBundle.RecLocationWizardPage_MISSING_FILE);
			}
			
			return false;
		}
		
		//Case 3 (default): Container and file exist:
		if(updateMessage){

			setMessage(null);
			setErrorMessage(null);
		}
		
		return true;
	}
}
