/*******************************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestsuiteLocationWizardPage.java,v 1.17 2010/05/05 12:32:46 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.tptp.test.provisional.recorder.ui.wizards;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.internal.execution.testgen.ui.wizards.FileLocationSelectionWizardpage;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.internal.util.ContextIds;
import org.eclipse.hyades.test.ui.wizard.TestLocationPage;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.viewers.IStructuredSelection;

/**
 * <p>Extension of the {@link FileLocationSelectionWizardpage} wizard for creating test suites from a recording.</p>
 * 
 * 
 * @author  Paul E. Slauenwhite
 * @author  Jeffery Nevicosi
 * @version May 4, 2010
 * @since   February 1, 2006
 */
public class TestsuiteLocationWizardPage extends FileLocationSelectionWizardpage implements IGenericRecorderPage {

	private IGenericRecorderWizard wizard;
	
	/**
	 * 
	 * @param wizard - the container IGenericRecorderWizard
	 */
	public TestsuiteLocationWizardPage(IGenericRecorderWizard wizard)
	{
		this(wizard, true);
	}
	
	/**
	 * 
	 * @param wizard - the container IGenericRecorderWizard
	 * @param bSaveLastSelected - when page is initially loaded, should the previous selection by preselected?
	 */
	public TestsuiteLocationWizardPage(IGenericRecorderWizard wizard, boolean bSaveLastSelected)
	{
		//Note: This wizard page may be instantiated without a wizard since the wizard can be set using org.eclipse.jface.wizard.WizardPage.setWizard(IWizard).
		super(bSaveLastSelected, (wizard != null ? ((IStructuredSelection)(wizard.getRecorderObjectData(IRecorderPageProvider.WIZARD_KEY_INITIAL_STRUCTURED_SELECTION))) : null));
		this.wizard = wizard;
		setWizard(wizard);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.DialogPage#setVisible(boolean)
	 */
	public void setVisible(boolean visible) {

		//Note: The wizard may be null since it is not required to instantiate this wizard page:
		if((visible) && (wizard != null)){

			//Set the recording file name (excluding extension) if exists (e.g. generating a test from an existing recording) as the default name for the test suite:
			String recordingPathString = wizard.getRecorderData(IRecorderPageProvider.WIZARD_KEY_RECORDING_PATH);

			if((recordingPathString != null) && (recordingPathString.length() > 0)){
				
				IPath recordingPath = new Path(recordingPathString).removeFileExtension();
				
				setContainerFullPath(recordingPath.removeLastSegments(1));
				setFileName(recordingPath.lastSegment());
			}
		}
		
		//Note: The super.setVisible(boolean) method selects the file name, which must be called after the file name is set.
		super.setVisible(visible);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.internal.execution.testgen.ui.wizards.FileLocationSelectionWizardpage#getDescription()
	 */
	public String getDescription() {
		return UiPluginResourceBundle.TestsuiteLocationWizardPage_DESCRIPTION;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.internal.execution.testgen.ui.wizards.FileLocationSelectionWizardpage#getFileExtension()
	 */
	public String getFileExtension() {
		return "testsuite";
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.internal.execution.testgen.ui.wizards.FileLocationSelectionWizardpage#getTitle()
	 */
	public String getTitle() {
		return UiPluginResourceBundle.NewRecordingWizardPage_TITLE;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.internal.execution.testgen.ui.wizards.ITestGenWizardPage#getContextHelpID()
	 */
	public String getContextHelpID() {		
		return (UiPlugin.getID() + ContextIds.NEW_TEST_FROM_RECORDING_WIZARD);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.test.provisional.recorder.ui.wizards.IGenericRecorderPage#getRecorderData(java.lang.String)
	 */
	public String getRecorderData(String key) {
		if (key.equals(IRecorderPageProvider.WIZARD_KEY_TESTGEN_PATH))
			return getFilePath();
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.test.provisional.recorder.ui.wizards.IGenericRecorderPage#getRecorderObjectData(java.lang.String)
	 */
	public Object getRecorderObjectData(String key) {
		return null;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.internal.execution.testgen.ui.wizards.FileLocationSelectionWizardpage#getPreferenceKey()
	 */
	protected String getPreferenceKey() {
		
		//Note: The wizard may be null since it is not required to instantiate this wizard page:
		return (super.getPreferenceKey() + (wizard != null ? wizard.getRecorderID() : ""));
	}	

	/**
	 * <p>Determines if the page's controls contain valid values.</p>
	 * 
	 * <p>Valid values require all of the following conditions (in order):</p>
	 * 
	 * <ol>
	 * <li>{@link TestLocationPage#validatePage(boolean)}</li>
	 * <li>The project is Java-capable.</li>
	 * </ol>
	 * 
	 * <p>If the values are not valid, an error message is displayed if the page's message is to be 
	 * updated and the method returns false.</p>
	 * 
	 * @param updateMessage <code>true</code> if the page's message is to be updated, otherwise <code>false</code>.
	 * @return <code>true</code> if the page's controls contain valid values, otherwise <code>false</code>.
	 * @see TestLocationPage#validatePage(boolean)
	 */
	protected boolean validatePage(boolean updateMessage){
	
		//Case 1: Container and/or file name are missing or invalid:
		if(!super.validatePage(updateMessage)){
			return false;
		}
		
		//Case 2: Project type is incorrect:
		try {					

			if(!ResourcesPlugin.getWorkspace().getRoot().getFile(new Path(getFilePath())).getProject().hasNature(JavaCore.NATURE_ID)){					

				if(updateMessage){

					setMessage(null);
					setErrorMessage(UiPluginResourceBundle.TestLocationPage_INCORRECT_CONTAINER_TYPE);
				}

				return false;
			}
		} 
		catch (Exception e) {

			//Rare Condition: Project does not exist or is not opened.
			if(updateMessage){

				setMessage(null);
				setErrorMessage(UiPluginResourceBundle.TestLocationPage_INCORRECT_CONTAINER_TYPE);
			}

			return false;
		}		
		
		//Case 3 (default): Container and file exist:
		if(updateMessage){

			setMessage(null);
			setErrorMessage(null);
		}
		
		return true;
	}
}
