/*******************************************************************************
 * Copyright (c) 2003, 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DatapoolIteratorImpl_Base.java,v 1.3 2006/02/08 19:59:54 slavescu Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
/*
 * Created on Dec 10, 2003
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package org.eclipse.hyades.datapool.iterator;

import java.util.HashMap;

import org.eclipse.hyades.execution.runtime.datapool.IDatapool;
import org.eclipse.hyades.execution.runtime.datapool.IDatapoolRecord;

/**
 * @author ahoppe
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class DatapoolIteratorImpl_Base {
	
				protected  /*static */  IDatapool myDatapool;
				protected  /*static */  boolean allEquivClasses;
             	
				protected  /*static */  int currentEquivClassIndex;
             	
				protected  /*static */  int currentRecordIndex;
             	
				protected  /*static */  int myEquivClassIndex;
				
				protected  /*static */  boolean done;
				
	            protected HashMap properties;

				/**
				 * Initialize the iterator sequence from the specified datapool object.
				 * Depending on the implementation of this method the iterator may use
				 * sequential or random access order, share a cursor with other processes
				 * or use a repeating sequence to access the records.  The order of access
				 * is left to the individual iterator implementations.
				 * 
				 * @param	datapool	The datapool to iterate over.
				 * @param	equivalenceClassIndex	The zero-based index of the equivalence
				 *						class that should be iterated over.  If this value
				 *						is negative then all records in the datapool should be
				 *						will be available to the iterator.
				 */
/*				public void dpInitialize(IDatapool datapool, int equivalenceClassIndex)
				{
					//synchronized(this) {
						myDatapool = datapool;				
						allEquivClasses = (equivalenceClassIndex < 0);
						if(allEquivClasses)
							currentEquivClassIndex = 0;
						else
							currentEquivClassIndex = equivalenceClassIndex;
						currentRecordIndex = 0;
						done = this.dpDone();
					//}				
				}
*/	
				/**
				 * This method acts the same way as {@link #dpInitialize(IDatapool,int) dpInitialize with equivalence class specification}
				 * except that {@link IDatapool#getDefaultEquivalenceClassIndex() default} 
				 * equivalence class is used.
				 * 
				 * @param	datapool	The datapool to iterate over.
				 */
/*				public void dpInitialize(IDatapool datapool)
				{
					this.dpInitialize(datapool, datapool.getDefaultEquivalenceClassIndex());
				}
*/	
				/**
				 * The datapool being iterated over.  If the iterator has not been initialized
				 * then <code>null</code> is returned.
				 * 
				 * @return	The datapool being iterated over.
				 */
				public IDatapool getDatapool()
				{
					return myDatapool;
				}
	
				/**
				 * The record currently available from this iterator for the associated
				 * instance of the datapool.  This method will return the same value
				 * repeated until the iterator is incremented by a call to the
				 * {@link #dpNext() next method}.  A value of <code>null</code> is 
				 * returned when the iterator is out of values.
				 * 
				 * @return	The current record in the itertion sequence or <code>null</code>.
				 * 
				 * @see	#dpNext()
				 * @see #dpDone()
				 * @see #dpReset()
				 */
				public IDatapoolRecord dpCurrent()
				{
					if (this.done)
						return null;
					else
						return myDatapool.getEquivalenceClass(currentEquivClassIndex)
													.getRecord(currentRecordIndex);
				}
	
				/**
				 * Returns <code>true</code> if the {@link #dpCurrent() current} iterator
				 * value is <code>null</code>.
				 * 
				 * @see	#dpCurrent()
				 * @see #dpNext()
				 * @see #dpReset()
				 */
/*				public boolean dpDone()
				{
					if (!allEquivClasses)
						return (currentRecordIndex == 
						myDatapool.getEquivalenceClass(currentEquivClassIndex).getRecordCount());
					else
						return (
						  (currentEquivClassIndex == myDatapool.getEquivalenceClassCount())
						  && 
						  (currentRecordIndex == 0)
						);
					    
				}
*/	
				/**
				 * Increments the iterator associated with an instance of the datapool.
				 * Calling this method after the iteration sequence has been exhausted has no
				 * effect.
				 * 
				 * @see	#dpCurrent()
				 * @see #dpDone()
				 * @see #dpReset()
				 */
/*				public void dpNext()
				{
					//synchronized(this) {
						if (!allEquivClasses)
						{
							if(currentRecordIndex < 
							myDatapool.getEquivalenceClass(currentEquivClassIndex).getRecordCount())
							   currentRecordIndex++;				    	
						}
						else 
						{
							if (currentEquivClassIndex < myDatapool.getEquivalenceClassCount())
								if(currentRecordIndex < 
								   myDatapool.getEquivalenceClass(currentEquivClassIndex).getRecordCount()-1)
									currentRecordIndex++;
								else
								{
									currentEquivClassIndex++;
									currentRecordIndex = 0;	
								}
						}
						if this.dpDone()
						    this.done = true;
                     //}
				}
*/	
				/**
				 * Restart the iterator associated with an instance of the datapool.
				 * It does not matter if the iterator has been exhausted of entries or
				 * not, the iterator simply resets to the initial start state.
				 * 
				 * @see	#dpCurrent()
				 * @see #dpDone()
				 * @see #dpNext()
				 */
/*				public void dpReset()
				{
					//synchronized(this) {
						if(allEquivClasses)
							this.dpInitialize(myDatapool, -1);
						else
							this.dpInitialize(myDatapool, currentEquivClassIndex);
					//}
				}
*/	
	
				//*********************************************************************
				// The remaining methods exist to simplify access to the cell values.
				// Basically allows access to cell value directly off the iterator rather 
				// then having to use the full specification.  For instance using 
				// "iter.dpString(name)" rather then "iter.dpCurrent().getCell(name).dpString()".
				//*********************************************************************
	
				/**
				 * Shortcut to the value in the cell in the {@link #dpCurrent() current} record and
				 * the specified variable index is returned.  The variable index is the specified zero 
				 * based index for the cell.
				 * 
				 * @param	variableIndex		The zero based index of the cell in the record.
				 * @return	The value in the cell in the {@link #dpCurrent() current} record and
				 *			at the specified index.
				 * 
				 * @see #dpValue(String)
				 */
				public Object dpValue(int variableIndex)
				{
					return this.dpCurrent().getCell(variableIndex).getCellValue();
				}
	
				/**
				 * Shortcut to the value in the cell in the {@link #dpCurrent() current} record and
				 * the specified variable name is returned.
				 * 
				 * @param	variableName	The variable name to locate the cell by.
				 * @return	The value in the cell in the {@link #dpCurrent() current} record and
				 *			the specified variable name.
				 * 
				 * @see #dpValue(int)
				 */
				public Object dpValue(String variableName)
				{
					return this.dpCurrent().getCell(variableName).getCellValue();
				}
	
				/**
				 * Shortcut to the <code>String</code> value in the cell in the {@link #dpCurrent() current} record and
				 * the specified variable index is returned.  The variable index is the specified zero 
				 * based index for the cell.
				 * 
				 * @param	variableIndex		The zero based index of the cell in the record.
				 * @return	The value in the cell in the {@link #dpCurrent() current} record and
				 *			at the specified index.
				 * 
				 * @see #dpString(String)
				 */
				public String dpString(int variableIndex)
				{
					return this.dpCurrent().getCell(variableIndex).getStringValue();
				}
	
				/**
				 * Shortcut to the <code>String</code> value in the cell in the {@link #dpCurrent() current} record and
				 * the specified variable name is returned.
				 * If the value in the cell is not a <code>String</code> value then it is
				 * converted to a <code>String</code> before being returned.
				 * 
				 * @param	variableName	The valiable name to locate the cell by.
				 * @return	The <code>String</code> value in the cell in the {@link #dpCurrent() current} record and
				 *			the specified variable name.
				 * 
				 * @see #dpString(int)
				 */
				public String dpString(String variableName)
				{
					return this.dpCurrent().getCell(variableName).getStringValue();
				}
	
				/**
				 * Shortcut to the <code>long</code> value in the cell in the {@link #dpCurrent() current} record and
				 * the specified variable index is returned.  The variable index is the specified zero 
				 * based index for the cell.
				 * 
				 * @param	variableIndex		The zero based index of the cell in the record.
				 * @return	The value in the cell in the {@link #dpCurrent() current} record and
				 *			at the specified index.
				 * 
				 * @see #dpLong(String)
				 */
				public long dpLong(int variableIndex)
				{
					return this.dpCurrent().getCell(variableIndex).getLongValue();
				}
	
				/**
				 * Shortcut to the <code>long</code> value in the cell in the {@link #dpCurrent() current} row and
				 * the specified variable name is returned.
				 * If the value in the cell is not a <code>long</code> value then an attempt
				 * is made to convert the value to a <code>long</code>.  If the value can not
				 * be converted a <code>java.lang.NumberFormatException</code> will be thrown.
				 * 
				 * @param	variableName	The variable name to locate the cell by.
				 * @return	The <code>long</code> value in the cell in the {@link #dpCurrent() current} row and
				 *			the specified variable name.
				 * 
				 * @see #dpLong(int)
				 */
				public long dpLong(String variableName)
				{
					return this.dpCurrent().getCell(variableName).getLongValue();
				}
	
				/**
				 * Shortcut to the <code>int</code> value in the cell in the {@link #dpCurrent() current} record and
				 * the specified variable index is returned.  The variable index is the specified zero 
				 * based index for the cell.
				 * If the value in the cell is not a <code>int</code> value then an attempt
				 * is made to convert the value to a <code>int</code>.  If the value can not
				 * be converted a <code>java.lang.NumberFormatException</code> will be thrown.
				 * 
				 * @param	variableIndex		The zero based index of the cell in the record.
				 * @return	The <code>int</code> value in the cell in the {@link #dpCurrent() current} record and
				 *			at the specified index.
				 * 
				 * @see #dpInt(String)
				 */
				public int dpInt(int variableIndex)
				{
					return this.dpCurrent().getCell(variableIndex).getIntValue();
				}
	
				/**
				 * Shortcut to the <code>int</code> value in the cell in the {@link #dpCurrent() current} row and
				 * the specified variable name is returned.
				 * If the value in the cell is not a <code>int</code> value then an attempt
				 * is made to convert the value to a <code>int</code>.  If the value can not
				 * be converted a <code>java.lang.NumberFormatException</code> will be thrown.
				 * 
				 * @param	variableName	The variable name to locate the cell by.
				 * @return	The <code>int</code> value in the cell in the {@link #dpCurrent() current} row and
				 *			the specified variable name.
				 * 
				 * @see #dpInt(int)
				 */
				public int dpInt(String variableName)
				{
					return this.dpCurrent().getCell(variableName).getIntValue();
				}
	
				/**
				 * Shortcut to the <code>short</code> value in the cell in the {@link #dpCurrent() current} record and
				 * the specified variable index is returned.  The variable index is the specified zero 
				 * based index for the cell.
				 * If the value in the cell is not a <code>short</code> value then an attempt
				 * is made to convert the value to a <code>short</code>.  If the value can not
				 * be converted a <code>java.lang.NumberFormatException</code> will be thrown.
				 * 
				 * @param	variableIndex		The zero based index of the cell in the record.
				 * @return	The <code>short</code> value in the cell in the {@link #dpCurrent() current} record and
				 *			at the specified index.
				 * 
				 * @see #dpShort(String)
				 */
				public short dpShort(int variableIndex)
				{
					return this.dpCurrent().getCell(variableIndex).getShortValue();
				}
	
				/**
				 * Shortcut to the <code>short</code> value in the cell in the {@link #dpCurrent() current} row and
				 * the specified variable name is returned.
				 * If the value in the cell is not a <code>short</code> value then an attempt
				 * is made to convert the value to a <code>short</code>.  If the value can not
				 * be converted a <code>java.lang.NumberFormatException</code> will be thrown.
				 * 
				 * @param	variableName	The variable name to locate the cell by.
				 * @return	The <code>short</code> value in the cell in the {@link #dpCurrent() current} row and
				 *			the specified variable name.
				 * 
				 * @see #dpShort(int)
				 */
				public short dpShort(String variableName)
				{
					return this.dpCurrent().getCell(variableName).getShortValue();
				}
	
				/**
				 * Shortcut to the <code>byte</code> value in the cell in the {@link #dpCurrent() current} record and
				 * the specified variable index is returned.  The variable index is the specified zero 
				 * based index for the cell.
				 * If the value in the cell is not a <code>byte</code> value then an attempt
				 * is made to convert the value to a <code>byte</code>.  If the value can not
				 * be converted a <code>java.lang.NumberFormatException</code> will be thrown.
				 * 
				 * @param	variableIndex		The zero based index of the cell in the record.
				 * @return	The <code>byte</code> value in the cell in the {@link #dpCurrent() current} record and
				 *			at the specified index.
				 * 
				 * @see #dpByte(String)
				 */
				public byte dpByte(int variableIndex)
				{
					return this.dpCurrent().getCell(variableIndex).getByteValue();
				}
	
				/**
				 * Shortcut to the <code>byte</code> value in the cell in the {@link #dpCurrent() current} row and
				 * the specified variable name is returned.
				 * If the value in the cell is not a <code>byte</code> value then an attempt
				 * is made to convert the value to a <code>byte</code>.  If the value can not
				 * be converted a <code>java.lang.NumberFormatException</code> will be thrown.
				 * 
				 * @param	variableName	The variable name to locate the cell by.
				 * @return	The <code>byte</code> value in the cell in the {@link #dpCurrent() current} row and
				 *			the specified variable name.
				 * 
				 * @see #dpByte(int)
				 */
				public byte dpByte(String variableName)
				{
					return this.dpCurrent().getCell(variableName).getByteValue();
				}
	
				/**
				 * Shortcut to the <code>double</code> value in the cell in the {@link #dpCurrent() current} record and
				 * the specified variable index is returned.  The variable index is the specified zero 
				 * based index for the cell.
				 * If the value in the cell is not a <code>double</code> value then an attempt
				 * is made to convert the value to a <code>double</code>.  If the value can not
				 * be converted a <code>java.lang.NumberFormatException</code> will be thrown.
				 * 
				 * @param	variableIndex		The zero based index of the cell in the record.
				 * @return	The <code>double</code> value in the cell in the {@link #dpCurrent() current} record and
				 *			at the specified index.
				 * 
				 * @see #dpDouble(String)
				 */
				public double dpDouble(int variableIndex)
				{
					return this.dpCurrent().getCell(variableIndex).getDoubleValue();
				}
	
				/**
				 * Shortcut to the <code>double</code> value in the cell in the {@link #dpCurrent() current} row and
				 * the specified variable name is returned.
				 * If the value in the cell is not a <code>double</code> value then an attempt
				 * is made to convert the value to a <code>double</code>.  If the value can not
				 * be converted a <code>java.lang.NumberFormatException</code> will be thrown.
				 * 
				 * @param	variableName	The variable name to locate the cell by.
				 * @return	The <code>double</code> value in the cell in the {@link #dpCurrent() current} row and
				 *			the specified variable name.
				 * 
				 * @see #dpDouble(int)
				 */
				public double dpDouble(String variableName)
				{				
					return this.dpCurrent().getCell(variableName).getDoubleValue();
				}
	
				/**
				 * Shortcut to the <code>float</code> value in the cell in the {@link #dpCurrent() current} record and
				 * the specified variable index is returned.  The variable index is the specified zero 
				 * based index for the cell.
				 * If the value in the cell is not a <code>float</code> value then an attempt
				 * is made to convert the value to a <code>float</code>.  If the value can not
				 * be converted a <code>java.lang.NumberFormatException</code> will be thrown.
				 * 
				 * @param	variableIndex		The zero based index of the cell in the record.
				 * @return	The <code>float</code> value in the cell in the {@link #dpCurrent() current} record and
				 *			at the specified index.
				 * 
				 * @see #dpFloat(String)
				 */
				public float dpFloat(int variableIndex)
				{
					return this.dpCurrent().getCell(variableIndex).getFloatValue();
				}
	
				/**
				 * Shortcut to the <code>float</code> value in the cell in the {@link #dpCurrent() current} row and
				 * the specified variable name is returned.
				 * If the value in the cell is not a <code>float</code> value then an attempt
				 * is made to convert the value to a <code>float</code>.  If the value can not
				 * be converted a <code>java.lang.NumberFormatException</code> will be thrown.
				 * 
				 * @param	variableName	The variable name to locate the cell by.
				 * @return	The <code>float</code> value in the cell in the {@link #dpCurrent() current} row and
				 *			the specified variable name.
				 * 
				 * @see #dpFloat(int)
				 */
				public float dpFloat(String variableName)
				{
					return this.dpCurrent().getCell(variableName).getFloatValue();
				}
	
				/**
				 * Shortcut to the <code>int</code> value in the cell in the {@link #dpCurrent() current} record and
				 * the specified variable index is returned.  The variable index is the specified zero 
				 * based index for the cell.
				 * If the value in the cell is not a <code>boolean</code> value then an attempt
				 * is made to convert the value to a <code>boolean</code>.  If the value can not
				 * be converted an appropriate exception will be thrown.
				 * 
				 * @param	variableIndex		The zero based index of the cell in the record.
				 * @return	The <code>boolean</code> value in the cell in the {@link #dpCurrent() current} record and
				 *			at the specified index.
				 * 
				 * @see #dpBoolean(String)
				 */
				public boolean dpBoolean(int variableIndex)
				{
					return this.dpCurrent().getCell(variableIndex).getBooleanValue();
				}
			    
	
				/**
				 * Shortcut to the <code>boolean</code> value in the cell in the {@link #dpCurrent() current} row and
				 * the specified variable name is returned.
				 * If the value in the cell is not a <code>boolean</code> value then an attempt
				 * is made to convert the value to a <code>boolean</code>.  If the value can not
				 * be converted an appropriate exception will be thrown.
				 * 
				 * @param	variableName	The variable name to locate the cell by.
				 * @return	The <code>boolean</code> value in the cell in the {@link #dpCurrent() current} row and
				 *			the specified variable name.
				 * 
				 * @see #dpBoolean(int)
				 */
				public boolean dpBoolean(String variableName)
				{
					return this.dpCurrent().getCell(variableName).getBooleanValue();
				}
	
				/**
				 * Shortcut to the <code>int</code> value in the cell in the {@link #dpCurrent() current} record and
				 * the specified variable index is returned.  The variable index is the specified zero 
				 * based index for the cell.
				 * If the value in the cell is not a <code>char</code> value then an attempt
				 * is made to convert the value to a <code>char</code>.  If more then one 
				 * character is represented in the value only the first character will be
				 * returned.
				 * 
				 * @param	variableIndex		The zero based index of the cell in the record.
				 * @return	The <code>char</code> value in the cell in the {@link #dpCurrent() current} record and
				 *			at the specified index.
				 * 
				 * @see #dpChar(String)
				 */
				public char dpChar(int variableIndex)
				{
					return this.dpCurrent().getCell(variableIndex).getCharValue();
				}
	
				/**
				 * Shortcut to the <code>char</code> value in the cell in the {@link #dpCurrent() current} row and
				 * the specified variable name is returned.
				 * If the value in the cell is not a <code>char</code> value then an attempt
				 * is made to convert the value to a <code>char</code>.  If more then one 
				 * character is represented in the value only the first character will be
				 * returned.
				 * 
				 * @param	variableName	The variable name to locate the cell by.
				 * @return	The <code>char</code> value in the cell in the {@link #dpCurrent() current} row and
				 *			the specified variable name.
				 * 
				 * @see #dpChar(int)
				 */
				public char dpChar(String variableName)
				{
					return this.dpCurrent().getCell(variableName).getCharValue();
				}
	
	/**
	 * Returns the <code>Object</code> associated with the specified property name.
	 * 
	 * @param	propertyName
	 * @return 	The <code>Object</code> assoicated with the specified property name.
	 */
	public Object getProperty(String propertyName)
	{	
		return(this.properties.get(propertyName));
	}
	
	
	/**
	 * Sets the property with the specified name with a value captued in the <code>Object</code>.
	 * 
	 * @param 	propertyName
	 * @param	propertyValue
	 */
	public void setProperty(String propertyName, Object propertyValue)
	{
		this.properties.put(propertyName, propertyValue);
	}
	


}
