/**********************************************************************
 * Copyright (c) 2003, 2010 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: GenerateConstants.java,v 1.11 2010/09/08 15:20:49 mreid Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.common;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupService;

import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.Calendar;

/**
 * * <p>Developer utility to create the <code>org.eclipse.hyades.loaders.common.GenerateConstants</code>
 * class in <code>C:/temp/ExecutionConstants.java</code> for check-in to CVS.</p>
 * 
 * 
 * @author  Marius Slavescu
 * @author  Ashish Mathur
 * @author  Joseph P. Toomey
 * @author  Paul Slauenwhite
 * @version January 6, 2010
 * @since   January 25, 2005
 */
public class GenerateConstants {
	//~ Static fields/initializers -----------------------------------------------------------------

	private static Class[] classes =
		{ 
			ExecutionXMLLoadersFactory.class,
			XMLtimedEventLoader.class,
			XMLwaitEventLoader.class,
			XMLexecutionEventLoader.class,
			XMLloopEventLoader.class,
			XMLtypedEventLoader.class,
			XMLmessageEventLoader.class,
			XMLverdictEventLoader.class,
			XMLinvocationEventLoader.class
		};
	private static Class[] lookUpServiceClasses =
		{
			//TraceLookupService.class
		};

	//~ Methods ------------------------------------------------------------------------------------

	public static void main(String[] args) {
		GenerateConstants generateConstants = new GenerateConstants();
		generateConstants.processClasses();
	}

	private void processClasses() {
		List list = new ArrayList();

		for (int i = 0; i < classes.length; i++) {
			addFieldsName(classes[i], list);
		}

		for (int i = 0; i < lookUpServiceClasses.length; i++) {
			addLookUpServiceName(lookUpServiceClasses[i], list);
		}


		Collections.sort(list,new Comparator(){
			public int compare(Object o1, Object o2) {
				return ((String[])o1)[0].compareTo(((String[])o2)[0]);
			}
		});

		PrintWriter out;
		try {
			out =
				new PrintWriter(
					new FileWriter("C:/temp/ExecutionConstants.java")); //$NON-NLS-1$
			out.println(
					"/**********************************************************************\n" //$NON-NLS-1$
					+ " * Copyright (c) 2003, 2010 IBM Corporation and others.\n" //$NON-NLS-1$
					+ " * All rights reserved.   This program and the accompanying materials\n" //$NON-NLS-1$
					+ " * are made available under the terms of the Eclipse Public License v1.0\n" //$NON-NLS-1$
					+ " * which accompanies this distribution, and is available at\n" //$NON-NLS-1$
					+ " * http://www.eclipse.org/legal/epl-v10.html\n" //$NON-NLS-1$
					+ " * $Id: GenerateConstants.java,v 1.11 2010/09/08 15:20:49 mreid Exp $\n" //$NON-NLS-1$
					+ " * \n" //$NON-NLS-1$
					+ " * Contributors:\n" //$NON-NLS-1$
					+ " * IBM - Initial API and implementation\n" //$NON-NLS-1$
					+ " **********************************************************************/\n" //$NON-NLS-1$
					+ "package org.eclipse.hyades.loaders.common;\n" //$NON-NLS-1$
					+ "\n" //$NON-NLS-1$
					+ "/**\n" //$NON-NLS-1$
					+ " * <p>Generated by {@link GenerateConstants}.</p>\n" //$NON-NLS-1$
					+ " * \n" //$NON-NLS-1$
					+ " * \n" //$NON-NLS-1$
					+ " * @author  Ashish K. Mathur\n" //$NON-NLS-1$
					+ " * @author  Joseph P. Toomey\n" //$NON-NLS-1$
					+ " * @version " //$NON-NLS-1$
					+ SimpleDateFormat.getPatternInstance("MMMM d, yyyy").format(Calendar.getInstance().getTime()) //$NON-NLS-1$
					+ "\n" //$NON-NLS-1$
					+ " * @since   January 25, 2005\n" //$NON-NLS-1$
					+ " */\n" //$NON-NLS-1$
					+ "public class ExecutionConstants {\n"); //$NON-NLS-1$

			for (Iterator iter = list.iterator(); iter.hasNext();) {
				String[] field = (String[]) iter.next();

					out.println(
						"\tprotected static final int " //$NON-NLS-1$
							+ field[0]
							+ "_int = " //$NON-NLS-1$
							+ LoadersUtils.getHashCode(field[1])
							+ ";"); //$NON-NLS-1$
			}
			out.println("}\n"); //$NON-NLS-1$
			out.close();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	private void addLookUpServiceName(Class class1, List list) {
		try {
			LookupService lookupService = (LookupService)class1.newInstance();
			for (Iterator iter = lookupService.getSupportedTypes().iterator(); iter.hasNext();) {
				Class element = (Class) iter.next();
				String name = element.getName();
				if(name.lastIndexOf('.')>0)
					name = name.substring(name.lastIndexOf('.')+1); 
				list.add(new String[]{name,element.getName()});
			}
		} catch (InstantiationException e) {
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		}
		
	}

	private void addFieldsName(Class theClass, List list) {

		try {
			Field[] fields = theClass.getDeclaredFields();
			for (int i = 0; i < fields.length; i++) {
				int mod = fields[i].getModifiers();
				if (Modifier.isProtected(mod) && Modifier.isStatic(mod) && Modifier.isFinal(mod) && fields[i].getType()==String.class)
				{
					Object value = fields[i].get(null);
					if(value!=null)
						list.add(new String[]{fields[i].getName(),value.toString()});
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
