/**********************************************************************
 * Copyright (c) 2003, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: XMLmessageEventLoader.java,v 1.3 2006/02/08 19:59:50 slavescu Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.common;

import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFMessageEvent;
import org.eclipse.hyades.models.common.testprofile.TPFSeverity;
import org.eclipse.hyades.models.common.testprofile.impl.Common_TestprofileFactoryImpl;

/**
 * @author amathur
 *
 * This is the message event loader.
 */
public class XMLmessageEventLoader extends XMLexecutionEventLoader {
	
	protected final static String EVENT_MESSAGE_SEVERITY = "severity";
	protected TPFSeverity severity = null;

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.loaders.util.XMLFragmentLoader#initialize(org.eclipse.hyades.loaders.util.HierarchyContext, java.lang.String)
	 */
	public void initialize(HierarchyContext context, String name) {
		super.initialize(context, name);
		severity = null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.loaders.util.XMLFragmentLoader#addAttribute(java.lang.String, java.lang.String)
	 */
	public void addAttribute(String name, String value) {
		printAttribute(name, value);
		switch (LoadersUtils.getHashCode(name)) {
		case ExecutionConstants.EVENT_MESSAGE_SEVERITY_int :
			severity = TPFSeverity.get(Integer.parseInt(value));
			break;

		default:
			super.addAttribute(name, value);
			break;
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.loaders.util.XMLFragmentLoader#addYourselfInContext()
	 */
	public void addYourselfInContext() {
		// Create the event
		TPFMessageEvent event = Common_TestprofileFactoryImpl.eINSTANCE.createTPFMessageEvent();
		
		// Now populate the specialized attributes
		event.setSeverity(severity);
		
		// populate the event with the base event attributes
		this.event = (TPFExecutionEvent) event;
		super.addYourselfInContext();
		super.addYourselfToContainer();
	}
	
	/**
	 * @see org.eclipse.hyades.loaders.common.XMLexecutionEventLoader#overwrite(org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent)
	 */
	protected void overwrite(TPFExecutionEvent match) {
		// @akmathur: Can't imagine why anybody would want to overwrite 
		// message events, but its here for completeness
		((TPFMessageEvent)match).setSeverity(((TPFMessageEvent) event).getSeverity());
		super.overwrite(match);		
	}
}
