/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: XMLannotatedVerdictEventLoader.java,v 1.8 2009/01/09 12:32:16 paules Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.common.provisional;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Iterator;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.xml.type.XMLTypeFactory;
import org.eclipse.hyades.loaders.common.XMLexecutionEventLoader;
import org.eclipse.hyades.loaders.common.XMLverdictEventLoader;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.common.common.CMNAnnotation;
import org.eclipse.hyades.models.common.common.CommonFactory;
import org.eclipse.hyades.models.common.util.FileUtil;
import org.eclipse.hyades.models.util.ModelDebugger;

/**
 * Annotated verdict event loader.  An annotation can be a file or byte array.
 * <p>
 * 
 * 
 * @author      Mark Victory
 * @author      Paul E. Slauenwhite
 * @version     March 31, 2006
 * @since       October 7, 2005
 * @provisional As of TPTP v4.1.0, this class is marked as 'provisional'.
 * @deprecated  As of TPTP V4.2.0, use {@link XMLexecutionEventLoader}.
 */
public class XMLannotatedVerdictEventLoader extends XMLverdictEventLoader{
	
	protected final static String EVENT_ANNOTATION = "annotation";
	protected final static String EVENT_ANNOTATION_FILENAME = "annotationFilename";
	protected final static String EVENT_ANNOTATION_TYPE = "annotationType";
	
	protected static final int EVENT_ANNOTATION_int = -1555043537;
	protected  static final int EVENT_ANNOTATION_FILENAME_int = -959184298;
	protected static final int EVENT_ANNOTATION_TYPE_int = 1444986633;	
	
	protected CMNAnnotation		annotation = null;
	protected String			annotationFilename = null;
	protected char[]			annotationCDATA = null;
	protected ArrayList			annotations = new ArrayList();

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.loaders.util.XMLFragmentLoader#initialize(org.eclipse.hyades.loaders.util.HierarchyContext, java.lang.String)
	 */
	public void initialize(HierarchyContext context, String name) 
	{
		super.initialize(context, name);

		annotation = null;
		annotationFilename = null;
		annotationCDATA = null;
		annotations.clear();
	}

	public void addAttribute(String name, String value) 
	{
		switch (LoadersUtils.getHashCode(name)) 
		{

			case EVENT_ANNOTATION_FILENAME_int :
				if (annotation != null) {
					annotationFilename = value;
				}
				break;
			
			case EVENT_ANNOTATION_TYPE_int :
				if (annotation != null) {
					annotation.setType(value);
				}
				break;

			default :
				super.addAttribute(name, value);
				break;
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.loaders.util.XMLFragmentLoader#addCharacters(char[], int, int)
	 */
	public void addCharacters(char[] data, int offset, int length) {
		// This method processes CDATA sections.  Any elements which expect to
		// have CDATA children need to make sure they add handlers to this method
		// and that the set an appropriate state in the startChild() method
		// that can be tested for here.
		if ( annotation != null )
		{
			if ( annotationCDATA == null )
			{
				annotationCDATA = new char[length];
				System.arraycopy(data, offset, annotationCDATA,0, length);
			}
			else
			{
				int size = annotationCDATA.length + length;
				char[] newData = new char[size];
				System.arraycopy(annotationCDATA, 0, newData, 0, annotationCDATA.length);
				System.arraycopy(data, offset, newData, annotationCDATA.length, length);
				annotationCDATA = newData;
				newData = null;
			}
		}
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.loaders.util.XMLFragmentLoader#startChild(java.lang.String)
	 */
	public void startChild(String name) {
		switch (LoadersUtils.getHashCode(name)) {
			case EVENT_ANNOTATION_int:
				annotation = CommonFactory.eINSTANCE.createCMNAnnotation();
				break;
			default:
				super.startChild(name);
		}
		super.startChild(name);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.loaders.util.XMLFragmentLoader#endChild(java.lang.String)
	 */
	public void endChild(String name) 
	{
		switch (LoadersUtils.getHashCode(name)) 
		{
			case EVENT_ANNOTATION_int:
				constructAnnotation();
				annotations.add(annotation);
				annotation = null;
				annotationFilename = null;
				annotationCDATA = null;
				break;
			default:
				super.endChild(name);
				break;
		}
	}
	
	/**
	 * 
	 */
	private void constructAnnotation() {
		File tempDir = FileUtil.getTempDir();
		try {
			File annotationFile = new File(tempDir, annotationFilename);
			FileOutputStream os = new FileOutputStream(annotationFile);
			os.write(XMLTypeFactory.eINSTANCE.createBase64Binary(new String(annotationCDATA)));
			os.close();
			URI uri = URI.createFileURI(annotationFile.getAbsolutePath());
			annotation.setURI(uri.toFileString());
		} catch (Exception e) {
			ModelDebugger.log(e);
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.loaders.util.XMLFragmentLoader#addYourselfInContext()
	 */
	public void addYourselfInContext()
	{
		// TODO Auto-generated method stub
		super.addYourselfInContext();
		// Now add all the annotations of that event
		if (annotations != null) {
			Iterator iter = annotations.iterator();
			while (iter.hasNext()) {
				CMNAnnotation a = (CMNAnnotation) iter.next();
				if (a != null) {
					event.getAnnotations().add(a);
					try {
						String uri = a.getURI();
						a.putFileAnnotation(URI.createFileURI(uri));
						File file = new File(uri);
						if ( file.exists())
							file.delete();
					} catch (Exception e) {
						ModelDebugger.log(e);
					}
				}
			}
		}
	}
}
