/**********************************************************************
 * Copyright (c) 2003, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TRCObjectEntry.java,v 1.4 2006/02/08 19:56:55 slavescu Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 * 
 * $Id: TRCObjectEntry.java,v 1.4 2006/02/08 19:56:55 slavescu Exp $
 **********************************************************************/
package org.eclipse.hyades.loaders.trace;

import org.eclipse.hyades.models.trace.TRCObject;

/**
 * @author slavescu
 */
public class TRCObjectEntry {
	private TRCObject[] data;
	/**
	 *
	 */

	public TRCObjectEntry() {
		super();
	}

	public TRCObject get(Class type)
	{
		if(data!=null)
		{
			for (int i = 0; i < data.length; i++) {
				if(((TRCObject)data[i]).getClass()==type)
					return data[i];
			}
		}
		return null;
	}
	public boolean put(Class type, TRCObject value)
	{
		if(data!=null)
		{
			for (int i = 0; i < data.length; i++) {
				if(((TRCObject)data[i]).getClass()==type)
				{
					data[i]=value;
					return true;
				}
			}
		}
		addValue(value);
		return false;
	}
	private void addValue(TRCObject value) {
		if(data==null)
		{
			data = new TRCObject[1];
			data[0]=value;
		}
		else
		{
			TRCObject[] newArray = new TRCObject[data.length+1];
			System.arraycopy(data,0,newArray,0,data.length);
			newArray[data.length]=value;
			data = newArray;
		}
	}
	public boolean remove(Class type)
	{
		if(data!=null)
		{
			for (int i = 0; i < data.length; i++) {
				if(((TRCObject)data[i]).getClass()==type)
				{
					remove(i);
					return true;
				}
			}
		}
		return false;
	}
	private void remove(long i) {
		if(data.length==1)
		{
			data=null;
			return;
		}
		int j = (int)i;
		TRCObject[] newArray = new TRCObject[data.length-1];
		System.arraycopy(data,0,newArray,0,j);
		System.arraycopy(data,j+1,newArray,j,data.length-j);
		data = newArray;
	}
	public long getId() {
		if(data!=null)
		{
			if(data.length>0)
				return data[0].getId(); //TODO return long instead of int
		}
		return -1;
	}
}
