/**********************************************************************
 * Copyright (c) 2003, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TraceXMLFragmentLoader.java,v 1.19 2007/02/19 22:15:01 slavescu Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 * 
 * $Id: TraceXMLFragmentLoader.java,v 1.19 2007/02/19 22:15:01 slavescu Exp $
 **********************************************************************/
package org.eclipse.hyades.loaders.trace;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.loaders.hierarchy.Constants;
import org.eclipse.hyades.loaders.hierarchy.IgnoredXMLFragmentLoader;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.TRCAnnotation;
import org.eclipse.hyades.models.hierarchy.TRCCollectionMode;
import org.eclipse.hyades.models.trace.TRCArrayClass;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCFullHeapObject;
import org.eclipse.hyades.models.trace.TRCFullTraceObject;
import org.eclipse.hyades.models.trace.TRCHeapDump;
import org.eclipse.hyades.models.trace.TRCHeapObject;
import org.eclipse.hyades.models.trace.TRCLanguageElement;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCObjectValue;
import org.eclipse.hyades.models.trace.TRCPrimitiveType;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TRCThreadEvent;
import org.eclipse.hyades.models.trace.TraceFactory;
import org.eclipse.hyades.models.trace.impl.TRCArrayClassImpl;
import org.eclipse.hyades.models.trace.impl.TRCClassImpl;
import org.eclipse.hyades.models.trace.impl.TRCFullHeapObjectImpl;
import org.eclipse.hyades.models.trace.impl.TRCFullTraceObjectImpl;
import org.eclipse.hyades.models.trace.impl.TRCHeapObjectImpl;
import org.eclipse.hyades.models.trace.impl.TRCMethodImpl;
import org.eclipse.hyades.models.trace.impl.TRCMethodWithLLDataImpl;
import org.eclipse.hyades.models.trace.impl.TRCThreadImpl;
/**
 * @author slavescu
 *  
 */
public class TraceXMLFragmentLoader extends IgnoredXMLFragmentLoader {
	//~ Static fields/initializers
	// -----------------------------------------------------------------
	protected static final String NAME = "name";
    protected static final String VALUE = "value";
	protected static final String OBJ_ID_REF = "objIdRef";
	protected static final String METHOD_ID_REF = "methodIdRef";
	protected static final String CLASS_ID_REF = "classIdRef";
	protected static final String THREAD_ID_REF = "threadIdRef";
	protected static final String TIME = "time";
	protected static final String CLASS_CLASS1 = "java/lang/Class";
	protected static final String CLASS_CLASS2 = "java.lang.Class";
    protected static final String SOURCE_NAME = "sourceName";
    protected static final String PRECISION = "precision";
    protected static final String LANGUAGE = "language";
    protected static final String ANNOTATION = "annotation";
	protected static final String UNKNOWN = TraceUtils.UNKNOWN;
	
	//~ Instance fields
	// ----------------------------------------------------------------------------
	protected TRCClass theClass;
	protected TRCHeapDump theHeapDump;
	protected TRCMethod theMethod;
	protected TRCObject theObject;
	protected TRCProcess theProcess;
	protected TRCThread theThread;
	protected VirtualObjectInfo virtualObject;
	protected boolean loadToModel;
	protected double time = 0;
	//    protected double zeroTime = 0;
	protected long classIdRef;
	protected int deltaSize = 0;
	protected int methodIdRef;
	protected int threadIdRef = 0;
	protected long precision;
	protected long objIdRef;
    protected String sourceName;
    protected String language;
	protected TRCClass aClass;
	protected TRCAnnotation currentAnnotation;
	protected StringBuffer currentAnnotationValueEntry = new StringBuffer();
	protected boolean currentAnnotationValueEntryActive;
	protected List annotations = new ArrayList();
	protected TRCObjectValue objectValue;
	protected boolean createVirtualObjects;
	protected boolean createClassObjects;

	//~ Methods
	// ------------------------------------------------------------------------------------
	public void addAttribute(String name, String value) {
		switch (LoadersUtils.getHashCode(name)) {
			case TraceConstants.TIME_int :
				time = LoadersUtils.parseTraceTime(value);
//				time = Double.parseDouble(value);
				break;
			case TraceConstants.THREAD_ID_REF_int :
				threadIdRef = Integer.parseInt(value);
				break;
			case TraceConstants.CLASS_ID_REF_int :
				classIdRef = Long.parseLong(value);
				break;
			case TraceConstants.METHOD_ID_REF_int :
				methodIdRef = Integer.parseInt(value);
				break;
			case TraceConstants.OBJ_ID_REF_int :
				objIdRef = Long.parseLong(value);
				break;
	        case TraceConstants.SOURCE_NAME_int:
	            sourceName = value;
	            break;
	        case TraceConstants.PRECISION_int:
	            precision = Long.parseLong(value);
	            break;
	        case TraceConstants.LANGUAGE_int:
	            language = value;
	            break;
	        case TraceConstants.VALUE_int:
				if (objectValue!=null) {
					objectValue.setStringValue(value);
				}
	        	if(currentAnnotation!=null)
	        		currentAnnotation.getValues().add(value);
	            break;
	        case TraceConstants.NAME_int:
	        	if(currentAnnotation!=null)
	        		currentAnnotation.setName(value);
	            break;
			default :
				break;
		}
	}
	public void initialize(HierarchyContext context, String name) {
		super.initialize(context, name);
		threadIdRef = 0;
		classIdRef = 0;
		methodIdRef = 0;
		objIdRef = 0;
		time = 0;
		theProcess = null;
		theThread = null;
		theClass = null;
		theMethod = null;
		theObject = null;
		virtualObject = null;
	}
	protected TRCClass getClassByIdRef(TRCThread thread, Class theObjectClass, int isArray) {
		TRCClass targetClass = null;
		TRCObject anObject = null;
		if (isArray > 0) {
			theClass = (TRCClass) LookupServiceExtensions.getInstance().locate(context, TRCArrayClassImpl.class, -classIdRef);
			if (theClass != null) {
				return theClass;
			}
			targetClass = (TRCClass) LookupServiceExtensions.getInstance().locate(context, TRCClassImpl.class, classIdRef);
			if (targetClass == null) {
				// support for multi dimensional arrays
				targetClass = (TRCClass) LookupServiceExtensions.getInstance().locate(context, TRCArrayClassImpl.class, classIdRef);
			}
		} else {
			theClass = (TRCClass) LookupServiceExtensions.getInstance().locate(context, TRCClassImpl.class, classIdRef);
			if (theClass != null) {
				return theClass;
			}
		}
		//        TRCProcess p = thread.getProcess();
		if (isArray > 0) {
			theClass = TraceFactory.eINSTANCE.createTRCArrayClass();
			theClass.setId(-classIdRef);
			((TRCArrayClass) theClass).setArrayType(TRCPrimitiveType.get(isArray));
		} else {
			theClass = TraceFactory.eINSTANCE.createTRCClass();
			theClass.setId(classIdRef);
		}
		if (targetClass != null) {
			TRCClass tc = TraceUtils.findClass(theProcess, targetClass.getName()+"[]",targetClass.getPackage().getName());
			if(tc!=null)
			{
				theClass = tc;
				theClass.setId(-classIdRef);
			}


			theClass.setName(targetClass.getName()+"[]");
			theClass.setLoadTime(createDeltaTime());
			theClass.setLoadedBy(thread);
			theClass.setPackage(targetClass.getPackage());
			if(createClassObjects)
			{
				// now add a class object
				anObject = getClassObjectByIdRef(-classIdRef, theObjectClass);
				theClass.getClassObjects().add(anObject);
				anObject.setSize(theClass.getSize());
				//adds the class object to the Class class
				TraceUtils.addClassObjectToClassClass(context, theProcess, anObject);
			}
			return theClass;
		}
		String name = UNKNOWN + classIdRef;
		String sourceName = name;
		theClass.setName(TraceUtils.className(name));
		theClass.setId(classIdRef);
		theClass.setLoadTime(createDeltaTime());
		TraceUtils.addClassToPackage(context, theClass, name, theProcess);
		TraceUtils.setSourceInfo(context, theProcess, theClass, sourceName,language);
		addLanguageIfRequired(theProcess.getLanguages());
		if (theProcess.getClassClass() == null) // if class Class not set
		{
			int h = LoadersUtils.getHashCode(name);
			if (h == TraceConstants.CLASS_CLASS1_int || h == TraceConstants.CLASS_CLASS2_int) //if
			// class
			// Class
			{
				theProcess.setClassClass(theClass);
			}
			//	else do nothing because a fake one will be created automaticaly
		}
		//        /* Look for the class object in the model if we have been given an
		// object Id*/
		//        theObject = (TRCObjectEntry)
		// LookupServiceExtensions.getInstance().locate(context,
		// TRCObjectEntry.class, LoadersUtils.getLookUpKey(-classIdRef));
		//        if (theObject == null) {
		// now add a class object
		anObject = getClassObjectByIdRef(-classIdRef, theObjectClass);
		anObject.setSize(theClass.getSize());
		theClass.getClassObjects().add(anObject);
		theClass.setLoadedBy(thread);
		//adds the class object to the Class class
		TraceUtils.addClassObjectToClassClass(context, theProcess, anObject);
		return theClass;
	}
	protected TRCObject getClassObjectByIdRef(long id, Class theObjectClass) {
		aClass = theProcess.getClassClass();
		if (aClass == null) {
			TraceUtils.addClassObjectToClassClass(context, theProcess, null);
			aClass = theProcess.getClassClass();
		}
		return createObjectAndClassObject(id, theObjectClass);
	}
	protected TRCMethod getMethodByIdRef(TRCClass theClass) {
		Class clazz = TraceUtils.isBooleanOptionEnabled(context,Constants.LLDATA_ENABLED) ? TRCMethodWithLLDataImpl.class : TRCMethodImpl.class;
		TRCMethod method = (TRCMethod) LookupServiceExtensions.getInstance().locate(context, clazz, methodIdRef);
		if (method == null) {
			method = createTRCMethod(theClass);
			method.setId(methodIdRef);
			method.setName(UNKNOWN + methodIdRef);
			method.setSignature("()");
			method.setDefiningClass(theClass);
		}
		return method;
	}
	/**
	 * @param theClass2
	 * @return
	 */
	protected TRCMethod createTRCMethod(TRCClass theClass2) {
		TRCMethod method = null;
		if(TraceUtils.isBooleanOptionEnabled(context,Constants.LLDATA_ENABLED))
			method = TraceFactory.eINSTANCE.createTRCMethodWithLLData();
		else		
			method = TraceFactory.eINSTANCE.createTRCMethod();		
		return method;
	}

	protected TRCObject getObjectByIdRef(long id, Class theObjectClass) {
		aClass = theClass;
		if (aClass == null) {
			theProcess = getProcess();
			aClass = theProcess.getClassClass();
			if (aClass == null) {
				TraceUtils.addClassObjectToClassClass(context, theProcess, null);
				aClass = theProcess.getClassClass();
			}
		}
		return createObjectAndClassObject(id, theObjectClass);
	}
	protected TRCProcess getProcess() {
		if (context.getAgent() == null) {
			LoadersUtils.createAgent(context);
		}
		TRCProcess p = TraceUtils.getProcess(context.getAgent());
		if (p == null) {
			//create the process
			p = TraceFactory.eINSTANCE.createTRCProcess();
			p.setId(context.getProcessProxy().getRuntimeId());
			p.setPid(context.getProcessProxy().getPid());
			p.setAgent(context.getAgent());
			p.setStartTime(createDeltaTime());
		}
		return p;
	}
	protected TRCThread getThreadByIdRef(TRCProcess p) {
		TRCThread thread = (TRCThread) LookupServiceExtensions.getInstance().locate(context, TRCThreadImpl.class, threadIdRef);
		if (thread == null) {
			thread = TraceFactory.eINSTANCE.createTRCThread();
			thread.setId(threadIdRef);
			thread.setName(UNKNOWN + threadIdRef);
			thread.setStartTime(createDeltaTime());
			thread.setProcess(p);
		}
		return thread;
	}
	protected double createDeltaTime() {
		double res = time - getZeroTime();
		if(getProcess()!=null && getProcess().getLastEventTime()<res )
			getProcess().setLastEventTime(res);
		return res;
	}
	protected TRCObject createObject(long id, Class theObjectClass) {
		if (theObjectClass == TRCHeapObjectImpl.class) {
			return createTRCHeapObject(id);
		}
		if (theObjectClass == TRCFullHeapObjectImpl.class) {
			return createTRCFullHeapObject(id);
		}
		if (theObjectClass == TRCFullTraceObjectImpl.class) {
			return createTRCFullTraceObject(id);
		}
		return createTRCObject(id);
	}
	protected TRCObject createObject(long id, Class theObjectClass, TRCObjectEntry objectEntry) {
		if (theObjectClass == TRCHeapObjectImpl.class) {
			return createTRCHeapObject(id, objectEntry);
		}
		if (theObjectClass == TRCFullHeapObjectImpl.class) {
			return createTRCHeapObject(id, objectEntry);
		}
		if (theObjectClass == TRCFullTraceObjectImpl.class) {
			return createTRCFullTraceObject(id, objectEntry);
		}
		return createTRCObject(id);
	}
	protected TRCObject createTRCFullTraceObject(long oId) {
		TRCFullTraceObject object = TraceFactory.eINSTANCE.createTRCFullTraceObject();
		object.setId(oId);
		object.setCreateTime(createDeltaTime());
		object.setThread(theClass.getLoadedBy());
		object.setIsA(aClass);
		object.setProcess(getTRCObjectProcess());
		return object;
	}
	protected TRCObject createTRCFullTraceObject(long oId, TRCObjectEntry objectEntry) {
		TRCFullTraceObject object = TraceFactory.eINSTANCE.createTRCFullTraceObject();
		object.setId(oId);
		TRCHeapObject o = (TRCHeapObject) objectEntry.get(TRCHeapObjectImpl.class);
		if (o != null) {
			object.setIsA(o.getIsA());
		} else {
			object.setIsA(theClass);
		}
		object.setCreateTime(createDeltaTime());
		object.setThread(theClass.getLoadedBy());
		object.setProcess(getTRCObjectProcess());
		return object;
	}
	protected TRCObject createTRCHeapObject(long oId) {
		TRCHeapObject object = TraceFactory.eINSTANCE.createTRCHeapObject();
		object.setId(oId);
		//		theObject.setCreateTime(createDeltaTime());
		//		theObject.setThread(theClass.getLoadedBy());
		object.setIsA(aClass);
		object.setProcess(getTRCObjectProcess());
		return object;
	}
	protected TRCObject createTRCFullHeapObject(long oId) {
		TRCFullHeapObject object = TraceFactory.eINSTANCE.createTRCFullHeapObject();
		object.setId(oId);
		//		theObject.setCreateTime(createDeltaTime());
		//		theObject.setThread(theClass.getLoadedBy());
		object.setIsA(aClass);
		object.setProcess(getTRCObjectProcess());
		return object;
	}
	protected TRCObject createTRCHeapObject(long oId, TRCObjectEntry objectEntry) {
		TRCHeapObject object = TraceFactory.eINSTANCE.createTRCHeapObject();
		object.setId(oId);
		//		theObject.setCreateTime(createDeltaTime());
		//		theObject.setThread(theClass.getLoadedBy());
		TRCFullTraceObject o = (TRCFullTraceObject) objectEntry.get(TRCFullTraceObjectImpl.class);
		if (o != null) {
			object.setIsA(o.getIsA());
		} else {
			object.setIsA(theClass);
		}
		object.setProcess(getTRCObjectProcess());
		return object;
	}
	protected TRCObject createTRCFullHeapObject(long oId, TRCObjectEntry objectEntry) {
		TRCFullHeapObject object = TraceFactory.eINSTANCE.createTRCFullHeapObject();
		object.setId(oId);
		//		theObject.setCreateTime(createDeltaTime());
		//		theObject.setThread(theClass.getLoadedBy());
		TRCFullTraceObject o = (TRCFullTraceObject) objectEntry.get(TRCFullTraceObjectImpl.class);
		if (o != null) {
			object.setIsA(o.getIsA());
		} else {
			object.setIsA(theClass);
		}
		object.setProcess(getTRCObjectProcess());
		return object;
	}
	protected TRCObject createTRCObject(long oId) {
		TRCObject object = TraceFactory.eINSTANCE.createTRCObject();
		object.setId(oId);
		//		theObject.setCreateTime(createDeltaTime());
		//		theObject.setThread(theClass.getLoadedBy());
		object.setIsA(aClass);
		object.setProcess(getTRCObjectProcess());
		return object;
	}
	protected void dispatchProcessMode(int step) {
		switch (context.getCollectionMode().getValue()) {
			case TRCCollectionMode.HEAP_STATISTICS_ONLY :
				createVirtualObjects=true;
				createClassObjects=true;
				processHS(step);
				break;
			case TRCCollectionMode.HEAP_FULL :
				createVirtualObjects=false;
				createClassObjects=false;
				processHF(step);
				break;
			case TRCCollectionMode.HEAP_AND_EXECUTION_FULL :
				createVirtualObjects=false;
				createClassObjects=true;
				processHF_EF(step);
				break;
			case TRCCollectionMode.HEAP_AND_EXECUTION_STATISTICS_ONLY :
				createVirtualObjects=true;
				createClassObjects=true;
				processHS_ES(step);
				break;
			case TRCCollectionMode.EXECUTION_NO_INSTANCES :
				createVirtualObjects=false;
				createClassObjects=false;
				processENI(step);
				break;
			case TRCCollectionMode.EXECUTION_FULL :
				createVirtualObjects=false;
				createClassObjects=true;
				processEF(step);
				break;
			case TRCCollectionMode.HEAP_FULL_AND_EXECUTION_STATISTICS_ONLY :
				createVirtualObjects=true;
				createClassObjects=false;
				processHF_ES(step);
				break;
			case TRCCollectionMode.EXECUTION_STATISTICS_ONLY :
				createVirtualObjects=true;
				createClassObjects=false;
				processES(step);
				break;
			case TRCCollectionMode.HEAP_STATISTICS_AND_EXECUTION_NO_INSTANCES :
				createVirtualObjects=true;
				createClassObjects=true;
				processHS_ENI(step);
				break;
			default :
				dynamicProcess(this, step);
				break;
		}
	}
	protected void processHS_ENI(int step) {
		processHS(step);
		processENI(step);
	}
	protected void dynamicProcess(TraceXMLFragmentLoader loader, int step) {
	}
	protected void processEF(int step) {
	}
	protected void processENI(int step) {
		processEF(step);
	}
	protected void processES(int step) {
	}
	protected void processHF(int step) {
	}
	protected void processHF_EF(int step) {
		processHF(step);
		processEF(step);
	}
	protected void processHF_ES(int step) {
		processHF(step);
		processES(step);
	}
	protected void processHS(int step) {
	}
	protected void processHS_ES(int step) {
		processHS(step);
		processES(step);
	}
	protected void updateVirtualObject(long oId, int size) {
		virtualObject = (VirtualObjectInfo) LookupServiceExtensions.getInstance().locate(context, VirtualObjectInfo.class, oId);
		if (virtualObject == null) {
			virtualObject = new VirtualObjectInfo();
			LoadersUtils.registerGenericLookUpEntry(context, LoadersUtils.getLookUpKey(oId), virtualObject);
		}
		//        size = TraceUtils.getObjectRealSize(isArray, size);
		virtualObject.myClass = theClass;
		virtualObject.myThread = theThread;
		virtualObject.createTime = createDeltaTime();
		virtualObject.size = size;
	}
	protected TRCProcess getTRCObjectProcess() {
		return getProcess();
	}
	protected double getZeroTime() {
		return getProcess().getAgent().getStartTime();
	}
	protected TRCObject createObjectAndClassObject(long id, Class theObjectClass) {
//		Object oKey = LoadersUtils.getLookUpKey(id);
		TRCObjectEntry objectEntry = (TRCObjectEntry) LookupServiceExtensions.getInstance().locate(context, TRCObjectEntry.class, id);
		TRCObject object = null;
		if (objectEntry != null) {
			object = objectEntry.get(theObjectClass);
			if (object == null) {
				object = createObject(id, theObjectClass, objectEntry);
				objectEntry.put(object.getClass(), object);
			}
		} else {
			object = createObject(id, theObjectClass);
			//          objectEntry = new TRCObjectEntry();
			//			objectEntry.put(object.getClass(),object);
			//			LoadersUtils.registerGenericLookUpEntry(context,oKey,objectEntry);
		}
		return object;
	}
	protected TRCObject getClassObject(TRCClass class1, Class class2) {
	    for (Iterator iter = class1.getClassObjects().iterator(); iter.hasNext();) {
	        TRCObject element = (TRCObject) iter.next();
	
	        if (element.getClass() == class2) {
	            return element;
	        }
	    }
	
	    TRCObject aObject = getClassObjectByIdRef(-classIdRef, class2);
	
	    aObject.setSize(class1.getSize());
	
	    theClass.getClassObjects().add(aObject);
	
	    TraceUtils.addClassObjectToClassClass(context, theProcess, aObject);
	
	    return aObject;
	}
	
	protected boolean addLanguageIfRequired(List languages) {
		return TraceUtils.addLanguageIfRequired(language,languages);
	}
	protected boolean addAnnotationsIfRequired(TRCLanguageElement target) {
		if(annotations!=null && annotations.size()>0)
		{
			target.getAnnotations().addAll(annotations);
			return true;
		}
		return false;
	}	
	
	protected boolean addAnnotationsIfRequired(TRCThreadEvent target) {
		if(annotations!=null && annotations.size()>0)
		{
			target.getAnnotations().addAll(annotations);
			return true;
		}
		return false;
	}	
	protected boolean addCopyOfAnnotationsIfRequired(TRCThreadEvent target) {
		if(annotations!=null && annotations.size()>0)
		{
			target.getAnnotations().addAll(EcoreUtil.copyAll(annotations));
			return true;
		}
		return false;
	}	
	protected boolean addAnnotationsIfRequired(TRCThread target) {
		if(annotations!=null && annotations.size()>0)
		{
			target.getAnnotations().addAll(annotations);
			return true;
		}
		return false;
	}	
	protected boolean addAnnotationsIfRequired(TRCProcess target) {
		if(annotations!=null && annotations.size()>0)
		{
			target.getAnnotations().addAll(annotations);
			return true;
		}
		return false;
	}	

	public void endChild(String name) {
		switch (LoadersUtils.getHashCode(name)) {
		case TraceConstants.ANNOTATION_int:
			annotations.add(currentAnnotation);
			currentAnnotation=null;
			break;
		case TraceConstants.VALUE_int:
			if(currentAnnotationValueEntryActive && currentAnnotationValueEntry.length()>0)
			{
				currentAnnotation.getValues().add(currentAnnotationValueEntry.toString().trim());
				currentAnnotationValueEntry.setLength(0);
				currentAnnotationValueEntryActive = false;
			}
			break;

		default:
			break;
		}
	}
	public void startChild(String name) {
		switch (LoadersUtils.getHashCode(name)) {
		case TraceConstants.ANNOTATION_int:
			currentAnnotation = HierarchyFactory.eINSTANCE.createTRCAnnotation();
			break;
		case TraceConstants.VALUE_int:
			if(currentAnnotation!=null)
			{
				currentAnnotationValueEntry.setLength(0);
				currentAnnotationValueEntryActive = true;
			}
			break;

		default:
			break;
		}
	}
	public void addCharacters(char[] data, int offset, int length) {
		if(currentAnnotationValueEntryActive)
		{
			currentAnnotationValueEntry.append(data,offset,length);
		}
	}
}
