/**********************************************************************
 * Copyright (c) 2008 Intel Corporation.
 * All rights reserved. This content is made available under
 * the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html       
 * $Id: TraceXMLThreadEventsLoader.java,v 1.6 2008/04/14 10:57:30 aalexeev Exp $
 *
 * Contributors:
 * Intel - Initial contribution
 **********************************************************************/

package org.eclipse.hyades.loaders.trace;

import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.models.trace.TRCFullTraceObject;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TRCThreadDeadEvent;
import org.eclipse.hyades.models.trace.TRCThreadEvent;
import org.eclipse.hyades.models.trace.TRCThreadExecEvent;
import org.eclipse.hyades.models.trace.TRCThreadRunningEvent;
import org.eclipse.hyades.models.trace.TRCThreadWaitingForJoinEvent;
import org.eclipse.hyades.models.trace.TRCThreadWaitingForLockEvent;
import org.eclipse.hyades.models.trace.TRCThreadWaitingForObjectEvent;
import org.eclipse.hyades.models.trace.TraceFactory;
import org.eclipse.hyades.models.trace.impl.TRCFullTraceObjectImpl;
import org.eclipse.hyades.models.trace.impl.TRCThreadSleepingEventImpl;

public class TraceXMLThreadEventsLoader extends TraceXMLFragmentLoader {

	final private double TIME_THRESHOLD = 0.1; //time threshold in seconds
	
	protected ThreadEventsContext getThreadEventsContext() {
		ThreadEventsContext threadEventsContext = 
			(ThreadEventsContext)context.getCustomData().get(ThreadEventsContext.class);
		if (null == threadEventsContext) {
			threadEventsContext = new ThreadEventsContext();
			context.getCustomData().put(ThreadEventsContext.class, threadEventsContext);
		}
		return threadEventsContext;
	}

	protected boolean canEventsBeBound(TRCThreadEvent runningEvent,
			TRCThreadEvent interactionEvent) {
		if (runningEvent.getTime() + TIME_THRESHOLD > interactionEvent.getTime()) {
			return true;
		}
		return false;
	}
	
	protected void addInteractionEvent(TRCThread thread, TRCThreadExecEvent execEvent) {
		int lastEventIndex = thread.getThreadEvents().size() - 1;
		TRCThreadEvent lastEvent = null;
		if (lastEventIndex >= 0) {
			lastEvent = (TRCThreadEvent)thread.getThreadEvents().get(lastEventIndex);
		}
		else {
			return;
		}
		
		if (lastEvent instanceof TRCThreadRunningEvent) {
			TRCThreadEvent runningEvent = TraceFactory.eINSTANCE.createTRCThreadRunningEvent();
			runningEvent.setTime(execEvent.getTime());
			runningEvent.setThread(execEvent.getThread());
			thread.getThreadEvents().add(execEvent);
			thread.getThreadEvents().add(runningEvent);
		}
		else if (lastEvent instanceof TRCThreadWaitingForObjectEvent || 
				 lastEvent instanceof TRCThreadWaitingForLockEvent || 
				 lastEvent instanceof TRCThreadWaitingForJoinEvent || 
				 lastEvent instanceof TRCThreadDeadEvent || 
				 lastEvent instanceof TRCThreadSleepingEventImpl) {
			execEvent.setTime(lastEvent.getTime());
			thread.getThreadEvents().add(lastEventIndex, execEvent);
		}
	} 
	
	protected TRCThreadEvent getLastEventForThread(TRCThread thread) {
		int lastIndex = thread.getThreadEvents().size() - 1;
		TRCThreadEvent lastEvent = null;
		if (lastIndex >= 0) {
			lastEvent = (TRCThreadEvent)thread.getThreadEvents().get(lastIndex);
		}
		return lastEvent; 
	}
	
	protected void processEF(int step) {
		super.processEF(step);
		if ((theObject == null) || !(theObject instanceof TRCFullTraceObject)) {
			theObject = (TRCFullTraceObject) LookupServiceExtensions.getInstance().locate(context, TRCFullTraceObjectImpl.class, objIdRef);
		}
	}
}
