/**********************************************************************
 * Copyright (c) 2003, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 * 
 * $Id: XMLmethodEntryLoader.java,v 1.16 2008/03/12 20:37:17 jkubasta Exp $
 **********************************************************************/
package org.eclipse.hyades.loaders.trace;
import org.eclipse.hyades.loaders.trace.TraceUtils.InvocationInfo;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCFullTraceObject;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TraceFactory;
import org.eclipse.hyades.models.trace.TracePackage;
import org.eclipse.hyades.models.trace.impl.TRCFullTraceObjectImpl;
import org.eclipse.hyades.models.util.ModelDebugger;
/**
 * @author slavescu
 *  
 */
public class XMLmethodEntryLoader extends TraceMethodBaseLoader {
	//~ Static fields/initializers
	// -----------------------------------------------------------------
	//    private static final String THREAD_ID_REF = "threadIdRef";
	//	protected static final String TICKET = "ticket";
	//	protected static final String STACK_DEPTH = "stackDepth";
	public void addAttribute(String name, String value) {
		if (!loadToModel) {
			return;
		}
		super.addAttribute(name, value);
	}
	public void addYourselfInContext() {
		if (!loadToModel) {
			return;
		}
		if(context.isFilterOn())
		{
			if(context.getFilterEngine().isFiltered(TracePackage.eINSTANCE.getTRCMethod_Name(),LoadersUtils.getLookUpKey(methodIdRef)))
			{
				return;
			}
		}
		if(remoteInvocationContext)
			activeInvocationContext=true;
		
		theProcess = getProcess();
		theThread = getThreadByIdRef(theProcess);
		cs = (CallStackPerThread) LookupServiceExtensions.getInstance().locate(context, CallStackPerThread.class, threadIdRef);
		if (cs == null) {
			Object csKey = LoadersUtils.getLookUpKey(threadIdRef);
			cs = new CallStackPerThread();
			LoadersUtils.registerGenericLookUpEntry(context, csKey, cs);
		}
		invocationPool = cs.invocationPool;
		dispatchProcessMode(ProcessSteps.ALL);
		setMaxStackDepth(theThread);
	}
	public void cleanUp(HierarchyContext context) {
		LookupServiceExtensions.getInstance().deregister(context, CallStackPerThread.class);
		super.cleanUp();
	}
	public void endChild(String name) {
	}
	public void initialize(HierarchyContext context, String name) {
		loadToModel = context.isLoadToModel();
		if (!loadToModel) {
			return;
		}
		super.initialize(context, name);
		fullInvoker = null;
	}
	public void startChild(String name) {
		if (!loadToModel) {
			return;
		}
		if (name.equals(INVOCATION_CONTEXT)) {
			setNullInvocationContext();
			activeInvocationContext = true;
		} else
			super.startChild(name);
	}

	protected void processENI(int step) {
		super.processEF(step);
		theClass = getClassByIdRef(theThread, TRCFullTraceObjectImpl.class, 0);
		theMethod = getMethodByIdRef(theClass);
		
		/* Create the method invocation element */
		fullInvocation = TraceFactory.eINSTANCE.createTRCFullMethodInvocation();
		fullInvocation.setStackDepth(stackDepth);
		fullInvocation.setEntryTime(createDeltaTime());
		fullInvocation.setTicket(ticket);
		fullInvocation.setMethod(theMethod);
		fullInvocation.setThread(theThread);
		fullInvocation.setProcess(theProcess);
        
		addInputOutputValues();
        
		synchronized (REMOTE_INVOCATION_RESOLUTION_LOCK) {
			setInvokerMethod(theThread, fullInvocation);
			updateForwardInvokes(fullInvocation);
		}
		
		if (cs.isEmpty()) {
			theThread.getInitialInvocations().add(fullInvocation);
		}
		if(useUpdateStatisticalInfoOld)
			updateStatisticalInfo(theThread, fullInvoker, fullInvocation, theMethod, (TRCFullTraceObject) theObject, theClass);
		else
			updateStatisticalInfoNew(theThread, fullInvoker, fullInvocation, theMethod, (TRCFullTraceObject) theObject, theClass);

		cs.push(invocationPool.allocInvocation(fullInvocation, cs));
		//        LookupServiceExtensions.getInstance().register(context,
		// fullInvocation);
	}
	
	/**
	 *  
	 */
	protected void processEF(int step) {
		super.processEF(step);
		theClass = getClassByIdRef(theThread, TRCFullTraceObjectImpl.class, 0);
		theMethod = getMethodByIdRef(theClass);
		if(createClassObjects) // treat TRCCollectionMode.EXECUTION_NO_INSTANCES case
		{
			if (objIdRef > 0) {
				theObject = getObjectByIdRef(objIdRef, TRCFullTraceObjectImpl.class);
			} else {
				theObject = getClassObject(theMethod.getDefiningClass(), TRCFullTraceObjectImpl.class);
			}
			if (theObject == null) {
				theObject = TraceFactory.eINSTANCE.createTRCFullTraceObject();
			}
		}
		/* Create the method invocation element */
		fullInvocation = TraceFactory.eINSTANCE.createTRCFullMethodInvocation();
		fullInvocation.setStackDepth(stackDepth);
		fullInvocation.setEntryTime(createDeltaTime());
		fullInvocation.setTicket(ticket);
		fullInvocation.setMethod(theMethod);
		fullInvocation.setThread(theThread);
		fullInvocation.setProcess(theProcess);
		fullInvocation.setOwningObject((TRCFullTraceObject) theObject);
        
		addInputOutputValues();
        
		synchronized (REMOTE_INVOCATION_RESOLUTION_LOCK) {
			setInvokerMethod(theThread, fullInvocation);
			updateForwardInvokes(fullInvocation);
		}
		
		if (cs.isEmpty()) {
			theThread.getInitialInvocations().add(fullInvocation);
		}
		if(useUpdateStatisticalInfoOld)
			updateStatisticalInfo(theThread, fullInvoker, fullInvocation, theMethod, (TRCFullTraceObject) theObject, theClass);
		else
			updateStatisticalInfoNew(theThread, fullInvoker, fullInvocation, theMethod, (TRCFullTraceObject) theObject, theClass);

		cs.push(invocationPool.allocInvocation(fullInvocation, cs));
		//        LookupServiceExtensions.getInstance().register(context,
		// fullInvocation);
	}
	/**
	 *  
	 */
	protected void processES(int step) {
		super.processES(step);
		theClass = getClassByIdRef(theThread, TRCFullTraceObjectImpl.class, 0);
		theMethod = getMethodByIdRef(theClass);
		if(createClassObjects)
		{
			if (objIdRef > 0) {
				virtualObject = (VirtualObjectInfo) LookupServiceExtensions.getInstance().locate(context, VirtualObjectInfo.class, objIdRef);
				if (virtualObject != null) {
					theObject = getClassObject(virtualObject.myClass, TRCFullTraceObjectImpl.class);
				}
			} else {
				theObject = getClassObject(theClass, TRCFullTraceObjectImpl.class);
			}
		}
		updateStatisticalInfoOnly(theMethod, (TRCFullTraceObject) theObject, theClass, theThread, createDeltaTime());
	}
	protected void updateStatisticalInfoNew(TRCThread aThread, TRCFullMethodInvocation invoker, TRCFullMethodInvocation invocation, TRCMethod aMethod, TRCFullTraceObject anObject, TRCClass aClass) {
		try {
			aMethod.setCalls(aMethod.getCalls() + 1);
			theProcess.setCalls(theProcess.getCalls() + 1);
			theProcess.setLastEventTime(invocation.getEntryTime());
			if (anObject != null) {
				anObject.setCalls(anObject.getCalls() + 1);
				invokerObjectClass = getExtendedClass(anObject, aClass);
				if (invokerObjectClass != null) {
					invokerObjectClass.setInheritedCalls(invokerObjectClass.getInheritedCalls() + 1);
					invokerObjectClass.getPackage().setInheritedCalls(invokerObjectClass.getPackage().getInheritedCalls() + 1);
					invokerObjectClass.getPackage().getProcess().setInheritedCalls(invokerObjectClass.getPackage().getProcess().getInheritedCalls() + 1);
				}
			}
			aClass.setCalls(aClass.getCalls() + 1);
			aClass.getPackage().setCalls(aClass.getPackage().getCalls() + 1);
//			if (invoker != null) {
//				int size = invoker.getInvokes().size();
//				if (size > 1) {
//					previousSiblingExitTime = ((TRCFullMethodInvocation) invoker.getInvokes().get(size - 2)).getExitTime();
//					deltaBaseTime = invocation.getEntryTime() - previousSiblingExitTime;
//				} else {
//					//this is first call from "invoker" to "invocation"
//					deltaBaseTime = invocation.getEntryTime() - invoker.getEntryTime();
//				}
//				invokerObject = (TRCFullTraceObject) invoker.getOwningObject();
//				invokerMethod = invoker.getMethod();
//				invokerClass = invoker.getMethod().getDefiningClass();
//				invokerObjectClass = getExtendedClass(invokerObject, invokerClass);
//				//update base and cumulative using deltaBaseTime, invokerObject
//				// and invokerClass
//				updateTimeStatistics();
//			}
			
//			if(fullInvocation.getInvokedBy()!=null)
//			{
//				TRCFullMethodInvocation parent = (TRCFullMethodInvocation)fullInvocation.getInvokedBy();
//				deltaCumulativeTime = fullInvocation.getEntryTime()-parent.getEntryTime();
//				deltaBaseTime = deltaCumulativeTime;
//				updateTimeStatisticsNew();
//			}
		} catch (Exception e) {
			ModelDebugger.log(e);
		}
	}
	
	/**
	 * Method updateStatisticalInfo.
	 * 
	 * @param invocation
	 * @param method
	 * @param theObject
	 * @param theClass
	 */
	protected void updateStatisticalInfo(TRCThread aThread, TRCFullMethodInvocation invoker, TRCFullMethodInvocation invocation, TRCMethod aMethod, TRCFullTraceObject anObject, TRCClass aClass) {
		try {
			aMethod.setCalls(aMethod.getCalls() + 1);
			theProcess.setCalls(theProcess.getCalls() + 1);
			theProcess.setLastEventTime(invocation.getEntryTime());
			if (anObject != null) {
				anObject.setCalls(anObject.getCalls() + 1);
				invokerObjectClass = getExtendedClass(anObject, aClass);
				if (invokerObjectClass != null) {
					invokerObjectClass.setInheritedCalls(invokerObjectClass.getInheritedCalls() + 1);
					invokerObjectClass.getPackage().setInheritedCalls(invokerObjectClass.getPackage().getInheritedCalls() + 1);
					invokerObjectClass.getPackage().getProcess().setInheritedCalls(invokerObjectClass.getPackage().getProcess().getInheritedCalls() + 1);
				}
			}
			aClass.setCalls(aClass.getCalls() + 1);
			aClass.getPackage().setCalls(aClass.getPackage().getCalls() + 1);
			if (invoker != null) {
				int size = invoker.getInvokes().size();
				if (size > 1) {
					previousSiblingExitTime = ((TRCFullMethodInvocation) invoker.getInvokes().get(size - 2)).getExitTime();
					deltaBaseTime = invocation.getEntryTime() - previousSiblingExitTime;
				} else {
					//this is first call from "invoker" to "invocation"
					deltaBaseTime = invocation.getEntryTime() - invoker.getEntryTime();
				}
				invokerObject = (TRCFullTraceObject) invoker.getOwningObject();
				invokerMethod = invoker.getMethod();
				invokerClass = invoker.getMethod().getDefiningClass();
				invokerObjectClass = getExtendedClass(invokerObject, invokerClass);
				//update base and cumulative using deltaBaseTime, invokerObject
				// and invokerClass
				updateTimeStatistics();
			}
		} catch (Exception e) {
			ModelDebugger.log(e);
		}
	}
	/**
	 * Method updateStatisticalInfoOnly.
	 */
	private void updateStatisticalInfoOnly(TRCMethod aMethod, TRCFullTraceObject anObject, TRCClass aClass, TRCThread aThread, double entryTime) {
		InvocationInfo invoker = null;
		if (!cs.isEmpty()) {
			invoker = (InvocationInfo) cs.peek();
		}
		updateStatisticalInfoOnlyExtra(invoker, entryTime, aMethod, anObject, aClass);
		cs.push(invocationPool.allocInvocation(cs, anObject, aClass, aMethod, entryTime));
		theProcess.setCalls(theProcess.getCalls() + 1);
		theProcess.setLastEventTime(entryTime);
	}
	private void updateStatisticalInfoOnlyExtra(InvocationInfo invoker, double entryTime, TRCMethod aMethod, TRCFullTraceObject anObject, TRCClass aClass) {
		try {
			aMethod.setCalls(aMethod.getCalls() + 1);
			if (anObject != null) {
				anObject.setCalls(anObject.getCalls() + 1);
				invokerObjectClass = getExtendedClass(anObject, aClass);
				if (invokerObjectClass != null) {
					invokerObjectClass.setInheritedCalls(invokerObjectClass.getInheritedCalls() + 1);
					invokerObjectClass.getPackage().setInheritedCalls(invokerObjectClass.getPackage().getInheritedCalls() + 1);
					invokerObjectClass.getPackage().getProcess().setInheritedCalls(invokerObjectClass.getPackage().getProcess().getInheritedCalls() + 1);
				}
			}
			aClass.setCalls(aClass.getCalls() + 1);
			aClass.getPackage().setCalls(aClass.getPackage().getCalls() + 1);
			aClass.getPackage().getProcess().setCalls(aClass.getPackage().getProcess().getCalls() + 1);
			if (invoker != null) {
				previousSiblingExitTime = invoker.getLastChildExitTime();
				if (previousSiblingExitTime > 0) {
					deltaBaseTime = entryTime - previousSiblingExitTime + invoker.getLastChildOverhead(); // bugzilla 123628
				} else {
					//this is first call from "invoker" to "invocation"
					deltaBaseTime = entryTime - invoker.getEntryTime();
				}
				invokerObject = invoker.getObject();
				invokerClass = invoker.getTheClass();
				invokerObjectClass = invoker.getObjectClass();
				invokerMethod = invoker.getMethod();
				//update base and cumulative using deltaBaseTime, invokerObject
				// and invokerClass
				updateTimeStatistics();
			}
		} catch (Exception e) {
			ModelDebugger.log(e);
		}
	}
}