/**********************************************************************
 * Copyright (c) 2003, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: XMLmonContendedEnteredLoader.java,v 1.12 2008/04/14 10:57:30 aalexeev Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 * Intel - loader is extended for contention analysis support  
 * 
 * $Id: XMLmonContendedEnteredLoader.java,v 1.12 2008/04/14 10:57:30 aalexeev Exp $
 **********************************************************************/
package org.eclipse.hyades.loaders.trace;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TRCThreadHandoffLockEvent;
import org.eclipse.hyades.models.trace.TRCThreadRunningEvent;
import org.eclipse.hyades.models.trace.TraceFactory;
import org.eclipse.hyades.models.trace.TracePackage;
public class XMLmonContendedEnteredLoader extends XMLmonContendedEnterLoader {
	public void addYourselfInContext() {
		if(context.isFilterOn())
		{
			if(context.getFilterEngine().isFiltered(TracePackage.eINSTANCE.getTRCThread_Name(),LoadersUtils.getLookUpKey(threadIdRef)))
			{
				return;
			}
		}

		theProcess = getProcess();
		theThread = getThreadByIdRef(theProcess);
		dispatchProcessMode(ProcessSteps.ALL);
		
		TRCThreadRunningEvent runningEvent = TraceFactory.eINSTANCE.createTRCThreadRunningEvent();
		runningEvent.setTime(createDeltaTime());//time);
		theThread.getThreadEvents().add(runningEvent);
		addAnnotationsIfRequired(runningEvent);
		
		TRCThread oldOwner = (TRCThread)getThreadEventsContext().getMonitor2OwnerMap().put(theObject, theThread);
		
		if (oldOwner != null && oldOwner != theThread) {
			TRCThreadHandoffLockEvent handoffEvent = 
				TraceFactory.eINSTANCE.createTRCThreadHandoffLockEvent();
		
			handoffEvent.setTime(createDeltaTime());
			handoffEvent.setLockedObject(theObject);
			handoffEvent.getRunningEvents().add(runningEvent);
			addInteractionEvent(oldOwner, handoffEvent);
		}
	}
}