/**********************************************************************
 * Copyright (c) 2003, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: XMLobjAllocLoader.java,v 1.13 2007/03/01 16:44:06 slavescu Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 * 
 * $Id: XMLobjAllocLoader.java,v 1.13 2007/03/01 16:44:06 slavescu Exp $
 **********************************************************************/
package org.eclipse.hyades.loaders.trace;
import org.eclipse.hyades.loaders.hierarchy.Constants;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.models.hierarchy.TRCAnnotation;
import org.eclipse.hyades.models.trace.TRCArrayClass;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCFullHeapObject;
import org.eclipse.hyades.models.trace.TRCFullTraceObject;
import org.eclipse.hyades.models.trace.TRCHeapObject;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCObjectAllocationAnnotation;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.TraceFactory;
import org.eclipse.hyades.models.trace.TracePackage;
import org.eclipse.hyades.models.trace.impl.TRCClassImpl;
import org.eclipse.hyades.models.trace.impl.TRCFullHeapObjectImpl;
import org.eclipse.hyades.models.trace.impl.TRCFullTraceObjectImpl;
import org.eclipse.hyades.models.trace.impl.TRCHeapObjectImpl;
import org.eclipse.hyades.models.trace.impl.TRCMethodImpl;
import org.eclipse.hyades.models.trace.impl.TRCMethodWithLLDataImpl;
public class XMLobjAllocLoader extends TraceXMLFragmentLoader {
	//~ Static fields/initializers
	// -----------------------------------------------------------------
	protected static final String SIZE = "size";
	protected static final String IS_ARRAY = "isArray";
	protected static final String OBJ_ID = "objId";
	protected static final String A_METHOD_ID_REF = "aMethodIdRef";
	protected static final String A_CLASS_ID_REF = "aClassIdRef";
	protected static final String A_LINE_NR = "aLineNr";
	//~ Instance fields
	// ----------------------------------------------------------------------------
	protected int isArray;
	protected int size,aMethodIdRef,aLineNr;
	protected long objId,aClassIdRef;
	protected short firstSeenIndex;
	//~ Methods
	// ------------------------------------------------------------------------------------
	public void addAttribute(String name, String value) {
		switch (LoadersUtils.getHashCode(name)) {
			case TraceConstants.OBJ_ID_int :
				objId = Long.parseLong(value);
				break;
			case TraceConstants.IS_ARRAY_int :
				isArray = Integer.parseInt(value);
				break;
			case TraceConstants.SIZE_int :
				size = Integer.parseInt(value);
				break;
			case TraceConstants.FIRST_SEEN_INDEX_int :
				firstSeenIndex = Short.parseShort(value);
				break;
			case TraceConstants.A_METHOD_ID_REF_int :
				aMethodIdRef = Integer.parseInt(value) ;
				break;
			case TraceConstants.A_CLASS_ID_REF_int :
				aClassIdRef = Long.parseLong(value);
				break;
			case TraceConstants.A_LINE_NR_int :
				aLineNr = Integer.parseInt(value);
				break;
			default :
				super.addAttribute(name, value);
				break;
		}
	}
	public void addYourselfInContext() {
		if(context.isFilterOn())
		{
			if(context.getFilterEngine().isFiltered(TracePackage.eINSTANCE.getTRCClass_Name(),LoadersUtils.getLookUpKey(classIdRef)))
			{
				return;
			}
		}
		if (!loadToModel) {
			if (objId >= 0) {
				theProcess = getProcess();
				theThread = getThreadByIdRef(theProcess);
				updateTheClass(TRCHeapObjectImpl.class);
				updateVirtualObject(objId, size);
			}
			return;
		}
		createTRCObject();
		if(aMethodIdRef>0)
		{
			Class clazz = TraceUtils.isBooleanOptionEnabled(context,Constants.LLDATA_ENABLED) ? TRCMethodWithLLDataImpl.class : TRCMethodImpl.class;
			TRCMethod allocMethod =  (TRCMethod) LookupServiceExtensions.getInstance().locate(context, clazz, aMethodIdRef);
			if(allocMethod!=null)
			{
				addAllocAnnotation(allocMethod);
			}
			else if(aClassIdRef>0){
					TRCClass allocClass = (TRCClass) LookupServiceExtensions.getInstance().locate(context, TRCClassImpl.class, aClassIdRef);
					if(allocClass!=null)
					{
						addAllocAnnotation(allocClass);
					}
				}
		}
		else if(aClassIdRef>0){
			TRCClass allocClass = (TRCClass) LookupServiceExtensions.getInstance().locate(context, TRCClassImpl.class, aClassIdRef);
			if(allocClass!=null)
			{
				addAllocAnnotation(allocClass);
			}
		}
	}
	private void addAllocAnnotation(TRCMethod allocMethod) {
		TRCObjectAllocationAnnotation allocationAnnotation = createAllocAnnotation();
		allocationAnnotation.getMethods().add(allocMethod);
	}
	private void addAllocAnnotation(TRCClass allocClass) {
		TRCObjectAllocationAnnotation allocationAnnotation = createAllocAnnotation();
		allocationAnnotation.getClasses().add(allocClass);
	}
	private TRCObjectAllocationAnnotation createAllocAnnotation() {
		TRCObjectAllocationAnnotation allocationAnnotation=null;
		for (int i = 0, length = theClass.getAnnotations().size(); i < length; i++) {
			TRCAnnotation annotation = (TRCAnnotation)theClass.getAnnotations().get(i);
			if(annotation instanceof TRCObjectAllocationAnnotation)
			{
				allocationAnnotation = (TRCObjectAllocationAnnotation) annotation;
			}
		}
		if(allocationAnnotation==null)
		{
			allocationAnnotation = TraceFactory.eINSTANCE.createTRCObjectAllocationAnnotation();
			allocationAnnotation.setName("objAllocInfo");
			theClass.getAnnotations().add(allocationAnnotation);
		}
		if(aLineNr!=-1)
			allocationAnnotation.getLineNumbers().add(new Integer(aLineNr));
		if(time>0)
			allocationAnnotation.getCreateTimes().add(new Double(createDeltaTime()));
		return allocationAnnotation;
	}
	public void initialize(HierarchyContext context, String name) {
		loadToModel = context.isLoadToModel();
		super.initialize(context, name);
		isArray = 0;
		objId = 0;
		size = 0;
		aMethodIdRef=0;
		aClassIdRef=0;
		aLineNr=-1;
	}
	//	private void updateSuperPackagesStatistics(TRCPackage thePackage, int s)
	// {
	//		thePackage = thePackage.getParent();
	//		if(thePackage!=null)
	//		{
	//			thePackage.setTotalInstances(thePackage.getTotalInstances()+1);
	//			thePackage.setTotalSize(thePackage.getTotalSize()+s);
	//			updateSuperPackagesStatistics(thePackage,size);
	//		}
	//	}
	/**
	 *  
	 */
	protected void processENI(int step) {
		if (step == ProcessSteps.GET_CLASS) {
			if (theClass != null) {
				return;
			}
			updateTheClass(TRCFullTraceObject.class);
		}
		else
		if ((step == ProcessSteps.GET_OBJECT) && (virtualObject == null) && (theObject == null)) {
			updateVirtualObject(objId, size);
		}
	}
	protected void processEF(int step) {
		super.processEF(step);
		switch (step) {
			case ProcessSteps.GET_CLASS :
				if (theClass != null) {
					break;
				}
				updateTheClass(TRCFullTraceObject.class);
				break;
			case ProcessSteps.GET_OBJECT :
				if ((theObject == null) || !(theObject instanceof TRCFullTraceObject)) {
					theObject = (TRCFullTraceObject) LookupServiceExtensions.getInstance().locate(context, TRCFullTraceObjectImpl.class, objId);
				}
				if (theObject == null) {
					theObject = TraceFactory.eINSTANCE.createTRCFullTraceObject();
				}
				//last update wins
				theObject.setId(objId);
				theObject.setSize(size);
				((TRCFullTraceObject) theObject).setCreateTime(createDeltaTime());
				((TRCFullTraceObject) theObject).setThread(theThread);
				theObject.setIsA(theClass);
				theObject.setProcess(theProcess);
				TraceUtils.removeVirtualObject(context, objId);
			default :
				break;
		}
	}
	
	
	/**
	 *  
	 */
	protected void processES(int step) {
		super.processES(step);
		if (step == ProcessSteps.GET_CLASS) {
			if (theClass != null) {
				return;
			}
			updateTheClass(TRCFullTraceObject.class);
		}
		else
		if ((step == ProcessSteps.GET_OBJECT) && (virtualObject == null) && (theObject == null)) {
			updateVirtualObject(objId, size);
		}
	}
	/**
	 *  
	 */
	protected void processHF(int step) {
		super.processHF(step);
		switch (step) {
			case ProcessSteps.GET_CLASS :
				if (theClass != null) {
					break;
				}
				Class clazz = (TraceUtils.isBooleanOptionEnabled(context,Constants.MULTIPLE_HEAP_DUMPS) ? TRCFullHeapObjectImpl.class : TRCHeapObjectImpl.class);
				updateTheClass(clazz);
				break;
			case ProcessSteps.GET_OBJECT :
				clazz = (TraceUtils.isBooleanOptionEnabled(context,Constants.MULTIPLE_HEAP_DUMPS) ? TRCFullHeapObjectImpl.class : TRCHeapObjectImpl.class);
				if ((theObject == null) || !(theObject instanceof TRCHeapObject)) {
					theObject = (TRCHeapObject) LookupServiceExtensions.getInstance().locate(context, clazz, objId);
				}
				if (theObject == null) {
					if (TraceUtils.isBooleanOptionEnabled(context,Constants.MULTIPLE_HEAP_DUMPS))
						theObject = TraceFactory.eINSTANCE.createTRCFullHeapObject();
					else
						theObject = TraceFactory.eINSTANCE.createTRCHeapObject();
				}
				//last update wins
				theObject.setId(objId);
				theObject.setProcess(theProcess);
				theObject.setIsA(theClass);
				theObject.setSize(size);
				// TODO Added By Piyush
				if (TraceUtils.isBooleanOptionEnabled(context,Constants.MULTIPLE_HEAP_DUMPS))
					((TRCFullHeapObject) theObject).setHeapDumpFirstSeen(firstSeenIndex);
				// Done
				if (virtualObject == null) {
					updateVirtualObject(objId, size);
				}
				break;
			default :
				break;
		}
	}
	/**
	 *  
	 */
	protected void processHS(int step) {
		super.processHS(step);
		if (step == ProcessSteps.GET_CLASS) {
			if (theClass != null) {
				return;
			}
			updateTheClass(TRCHeapObjectImpl.class);
		}
		else
		if ((step == ProcessSteps.GET_OBJECT) && (virtualObject == null) && (theObject == null)) {
			updateVirtualObject(objId, size);
		}
	}
	private void createTRCObject() {
		theProcess = getProcess();
		if (objId == 0) {
			objId = -classIdRef;
		}
		theThread = getThreadByIdRef(theProcess);
		if (objId >= 0) {
			dispatchProcessMode(ProcessSteps.GET_CLASS);
			dispatchProcessMode(ProcessSteps.GET_OBJECT);
			updateClassStatistics(size);
		}
	}
	private void updateClassStatistics(int s) {
		theClass.setTotalInstances(theClass.getTotalInstances() + 1);
		theClass.setTotalSize(theClass.getTotalSize() + s);
		TRCPackage thePackage = theClass.getPackage();
		thePackage.setTotalInstances(thePackage.getTotalInstances() + 1);
		thePackage.setTotalSize(thePackage.getTotalSize() + s);
		theProcess.setTotalInstances(theProcess.getTotalInstances() + 1);
		theProcess.setTotalSize(theProcess.getTotalSize() + s);
		//		updateSuperPackagesStatistics(thePackage,size);
	}
	private void updateTheClass(Class classObject) {
		theClass = getClassByIdRef(theThread, classObject, isArray);
		if ((isArray > 0) && (((TRCArrayClass) theClass).getElementType() == null)) {
			TRCClass elementType = (TRCClass) LookupServiceExtensions.getInstance().locate(context, TRCClassImpl.class, classIdRef);
			((TRCArrayClass) theClass).setElementType(elementType);
		}
	}
}
