/**********************************************************************
 * Copyright (c) 2003, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: XMLruntimeShutdownLoader.java,v 1.5 2006/02/08 19:56:55 slavescu Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 * 
 * $Id: XMLruntimeShutdownLoader.java,v 1.5 2006/02/08 19:56:55 slavescu Exp $
 **********************************************************************/
package org.eclipse.hyades.loaders.trace;

import java.util.Iterator;

import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TRCThread;


/**
 * @author slavescu
 *
 */
public class XMLruntimeShutdownLoader extends TraceXMLFragmentLoader {
    //~ Methods ------------------------------------------------------------------------------------

    /* (non-Javadoc)
     * @see org.eclipse.hyades.loaders.util.XMLFragmentLoader#addYourselfInContext(org.eclipse.hyades.loaders.util.HierarchyContext)
     */
    public void addYourselfInContext() {
        TRCProcess p = getProcess();

        p.setStopTime(createDeltaTime());

        for (Iterator iter = p.getThreads().iterator(); iter.hasNext();) {
            TRCThread thread = (TRCThread) iter.next();

            if (thread.getStopTime() == 0) {
                thread.setStopTime(createDeltaTime());
            }
        }
    }

    /* (non-Javadoc)
     * @see org.eclipse.hyades.loaders.util.XMLFragmentLoader#initialize(org.eclipse.hyades.loaders.util.HierarchyContext, java.lang.String)
     */
    public void initialize(HierarchyContext context, String name) {
        super.initialize(context, name);
    }
}
