/**********************************************************************
 * Copyright (c) 2010 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: XMLthreadSleepEndLoader.java,v 1.1 2010/05/11 16:30:05 jwest Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 
 * $Id: XMLthreadSleepEndLoader.java,v 1.1 2010/05/11 16:30:05 jwest Exp $
 **********************************************************************/
package org.eclipse.hyades.loaders.trace;
import java.util.Iterator;
import java.util.List;

import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.trace.TRCThreadRunningEvent;
import org.eclipse.hyades.models.trace.TRCThreadSleepingEvent;
import org.eclipse.hyades.models.trace.TraceFactory;
import org.eclipse.hyades.models.trace.TracePackage;

public class XMLthreadSleepEndLoader extends TraceXMLThreadEventsLoader {
	//~ Static fields/initializers
	// -----------------------------------------------------------------

	//~ Instance fields
	// ----------------------------------------------------------------------------
	
	//~ Methods
	// ------------------------------------------------------------------------------------
	public void addAttribute(String name, String value) {
			super.addAttribute(name, value);
	}

	private TRCThreadSleepingEvent createThreadSleepingEvent() {
		ThreadSleepStartEntry lastEntry = null;
		List/*<Object>*/ sleepData = getThreadEventsContext().getThreadSleepData(theThread.getId());
		
		// Get the most recent ThreadSleepStartEntry from the list
		for(Iterator it = sleepData.iterator(); it.hasNext();) {
			Object o = it.next();
			if(o instanceof ThreadSleepStartEntry) {
				lastEntry = (ThreadSleepStartEntry)o;
			}
		}
		
		if(lastEntry == null) {
			return null;
		}
		
		sleepData.remove(lastEntry);

		TRCThreadSleepingEvent sleepingEvent = TraceFactory.eINSTANCE.createTRCThreadSleepingEvent();
		
		long sleepTimeInMsecs = (long)((time - lastEntry.getThreadSleepStartTime()) * 1000);
		sleepingEvent.setSleepingTime( (int) sleepTimeInMsecs);
		
		sleepingEvent.setTime(lastEntry.getThreadSleepStartTime()- getZeroTime());

		sleepingEvent.setThread(theThread);

		addAnnotationsIfRequired(sleepingEvent);
		
		return sleepingEvent;
	}
	
	public void addYourselfInContext() {
		if(context.isFilterOn())
		{
			if(context.getFilterEngine().isFiltered(TracePackage.eINSTANCE.getTRCThread_Name(),LoadersUtils.getLookUpKey(threadIdRef)))
			{
				return;
			}
		}
		
		theProcess = getProcess();
		theThread = getThreadByIdRef(theProcess);
		dispatchProcessMode(ProcessSteps.ALL);
		
		TRCThreadSleepingEvent sleepingEvent = createThreadSleepingEvent();
		if(sleepingEvent != null) {
			theThread.getThreadEvents().add(sleepingEvent);
		}
		
		// Create a running event for after the sleeping event
		TRCThreadRunningEvent runningEvent = TraceFactory.eINSTANCE.createTRCThreadRunningEvent();
		runningEvent.setTime(createDeltaTime());//time);
		addAnnotationsIfRequired(runningEvent);
		theThread.getThreadEvents().add(runningEvent);
		
	}
	public void initialize(HierarchyContext context, String name) {
		loadToModel = context.isLoadToModel();
		super.initialize(context, name);
		annotations.clear();
		currentAnnotationValueEntryActive=false;
	}

	protected void processHF(int step) {
		super.processHF(step);
//		Class clazz = (TraceUtils.isBooleanOptionEnabled(context,Constants.MULTIPLE_HEAP_DUMPS) ? TRCFullHeapObjectImpl.class : TRCHeapObjectImpl.class);
//		if ((theObject == null) || !(theObject instanceof TRCHeapObject)) {
//			theObject = (TRCHeapObject) LookupServiceExtensions.getInstance().locate(context, clazz, objIdRef);
//		}
	}
}