/**********************************************************************
 * Copyright (c) 2010 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: XMLthreadSleepStartLoader.java,v 1.1 2010/05/11 16:30:04 jwest Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 
 * $Id: XMLthreadSleepStartLoader.java,v 1.1 2010/05/11 16:30:04 jwest Exp $
 **********************************************************************/
package org.eclipse.hyades.loaders.trace;
import java.util.List;

import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.trace.TracePackage;
public class XMLthreadSleepStartLoader extends TraceXMLThreadEventsLoader {
	//~ Static fields/initializers
	// -----------------------------------------------------------------

	//~ Instance fields
	// ----------------------------------------------------------------------------


	//~ Methods
	// ------------------------------------------------------------------------------------
	public void addAttribute(String name, String value) {		
			super.addAttribute(name, value);
	}
	
	public void addYourselfInContext() {
		if(context.isFilterOn())
		{
			if(context.getFilterEngine().isFiltered(TracePackage.eINSTANCE.getTRCThread_Name(),LoadersUtils.getLookUpKey(threadIdRef)))
			{
				return;
			}
		}
		
		theProcess = getProcess();
		theThread = getThreadByIdRef(theProcess);
		dispatchProcessMode(ProcessSteps.ALL);
		
		if(theThread == null) {
			return;
		}

		List/*<Object>*/ sleepData = getThreadEventsContext().getThreadSleepData(theThread.getId());
		
		ThreadSleepStartEntry te = new ThreadSleepStartEntry();
		te.setThreadSleepStartTime(time);
		sleepData.add(te);

	}
	
	public void initialize(HierarchyContext context, String name) {
		loadToModel = context.isLoadToModel();
		super.initialize(context, name);
		annotations.clear();
		currentAnnotationValueEntryActive=false;
	}

	protected void processHF(int step) {
		super.processHF(step);
//		Class clazz = (TraceUtils.isBooleanOptionEnabled(context,Constants.MULTIPLE_HEAP_DUMPS) ? TRCFullHeapObjectImpl.class : TRCHeapObjectImpl.class);
//		if ((theObject == null) || !(theObject instanceof TRCHeapObject)) {
//			theObject = (TRCHeapObject) LookupServiceExtensions.getInstance().locate(context, clazz, objIdRef);
//		}
	}
}

class ThreadSleepStartEntry {
	double threadSleepStartTime = -1;
	
	public ThreadSleepStartEntry() {
	}
		
	public double getThreadSleepStartTime() {
		return threadSleepStartTime;
	}
	
	public void setThreadSleepStartTime(double threadSleepStartTime) {
		this.threadSleepStartTime = threadSleepStartTime;
	}
}