/**********************************************************************
 * Copyright (c) 2008 Intel Corporation.
 * All rights reserved. This content is made available under
 * the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html       
 * $Id: XMLthreadStartCalledLoader.java,v 1.4 2008/04/14 10:57:30 aalexeev Exp $
 *
 * Contributors:
 * Intel - Initial contribution
 **********************************************************************/  

package org.eclipse.hyades.loaders.trace;

import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.trace.TRCThreadStartThreadEvent;
import org.eclipse.hyades.models.trace.TraceFactory;
import org.eclipse.hyades.models.trace.TracePackage;

public class XMLthreadStartCalledLoader extends TraceXMLThreadEventsLoader {
	public void addYourselfInContext() {
		if(context.isFilterOn())
		{
			if(context.getFilterEngine().isFiltered(TracePackage.eINSTANCE.getTRCThread_Name(),LoadersUtils.getLookUpKey(threadIdRef)))
			{
				return;
			}
		}
		
		theProcess = getProcess();
		theThread = getThreadByIdRef(theProcess);
		dispatchProcessMode(ProcessSteps.ALL);
		
		TRCThreadStartThreadEvent startEvent = 
			TraceFactory.eINSTANCE.createTRCThreadStartThreadEvent();
		
		startEvent.setTime(createDeltaTime());	
		addAnnotationsIfRequired(startEvent);
	    addInteractionEvent(theThread, startEvent);
	    
		getThreadEventsContext().getThreadObj2CallStartEventMap().put(theObject, startEvent);
	}	

}
