/**********************************************************************
 * Copyright (c) 2003, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: XMLthreadStartLoader.java,v 1.14 2008/03/14 17:36:31 aalexeev Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 * Intel - loader is extended for contention analysis support  
 *   
 * $Id: XMLthreadStartLoader.java,v 1.14 2008/03/14 17:36:31 aalexeev Exp $
 **********************************************************************/
package org.eclipse.hyades.loaders.trace;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.models.trace.TRCHeapObject;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TRCThreadRunningEvent;
import org.eclipse.hyades.models.trace.TRCThreadStartThreadEvent;
import org.eclipse.hyades.models.trace.TraceFactory;
import org.eclipse.hyades.models.trace.TracePackage;
import org.eclipse.hyades.models.trace.impl.TRCHeapObjectImpl;
import org.eclipse.hyades.models.trace.impl.TRCThreadImpl;
/**
 * @author slavescu
 *  
 */
public class XMLthreadStartLoader extends TraceXMLThreadEventsLoader {
	//~ Instance fields
	// ----------------------------------------------------------------------------
	//    protected static final String OBJ_ID_REF = "objIdRef";
	protected static final String GROUP_NAME = "groupName";
	protected static final String PARENT_NAME = "parentName";
	protected static final String THREAD_NAME = "threadName";
	protected static final String THREAD_ID = "threadId";
	private String groupName;
	private String parentName;
	private String threadName;
	private int threadId;
//	private long objIdRef;
	//~ Methods
	// ------------------------------------------------------------------------------------
	public void addAttribute(String name, String value) {
		switch (LoadersUtils.getHashCode(name)) {
			case TraceConstants.THREAD_ID_int :
				threadId = Integer.parseInt(value);
				break;
			case TraceConstants.THREAD_NAME_int :
				threadName = value;
				break;
			case TraceConstants.PARENT_NAME_int :
				parentName = value;
				break;
			case TraceConstants.GROUP_NAME_int :
				groupName = value;
				break;
			default :
				super.addAttribute(name, value);
				break;
		}
	}
	public void addYourselfInContext() {
		if(context.isFilterOn())
		{
			if(context.getFilterEngine().isFiltered(TracePackage.eINSTANCE.getTRCThread_Name(),LoadersUtils.getLookUpKey(threadId),threadName))
			{
				return;
			}
		}
		/* If we didn't get a group name */
		if (groupName == null) {
			groupName = UNKNOWN;
		}
		/* If we didn't get a parent thread name */
		if ((parentName == null) || parentName.equals("(null)")) {
			parentName = UNKNOWN;
		}
		if ((threadId != 0) && (threadName != null)) {
			TRCThread thread = (TRCThread) LookupServiceExtensions.getInstance().locate(context, TRCThreadImpl.class, threadId);
			if (thread == null) {
				thread = TraceFactory.eINSTANCE.createTRCThread();
				thread.setId(threadId);
				thread.setProcess(getProcess());
			}
			//last update wins
			thread.setName(threadName);
			thread.setGroupName(groupName);
			thread.setStartTime(createDeltaTime());
			dispatchProcessMode(ProcessSteps.ALL);

			thread.setThreadObject(theObject);
			// TODO: bind thread with parent base on names comparison 

			TRCThreadRunningEvent event = TraceFactory.eINSTANCE.createTRCThreadRunningEvent();
			event.setTime(thread.getStartTime());
			thread.getThreadEvents().add(event);
			addAnnotationsIfRequired(thread);
			
			getThreadEventsContext().getObject2ThreadMap().put(theObject, thread);
			
			TRCThreadStartThreadEvent startEvent = (TRCThreadStartThreadEvent)getThreadEventsContext()
				.getThreadObj2CallStartEventMap().get(theObject);
			
			if (startEvent != null) {
				startEvent.setStartedThread(thread);
				startEvent.getRunningEvents().add(event);
				getThreadEventsContext().getThreadObj2CallStartEventMap().remove(theObject);
			}			
		}
	}
	public void initialize(HierarchyContext context, String name) {
		super.initialize(context, name);
		threadId = 0;
		groupName = null;
		parentName = null;
		threadName = null;
		objIdRef = 0;
		annotations.clear();
	}
	
	protected void processHF(int step) {
		if (theObject == null) {
			theObject = (TRCHeapObject) LookupServiceExtensions.getInstance().locate(context, TRCHeapObjectImpl.class, objIdRef);
		}
		if (theObject == null) {
			virtualObject = (VirtualObjectInfo) LookupServiceExtensions.getInstance().locate(context, VirtualObjectInfo.class, objIdRef);
			if (virtualObject != null) {
				theObject = TraceFactory.eINSTANCE.createTRCObject();
				theObject.setId(objIdRef);
				theObject.setIsA(virtualObject.myClass);
				theObject.setProcess(getProcess());
				theObject.setSize(virtualObject.size);
			}
		}
	}	
	protected void processHS(int step) {
		processHF(step);
	}	
}