/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SDSampleWindow.java,v 1.4 2009/05/05 15:49:21 paules Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.model.statistical;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>SD Sample Window</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * This is a window of data.  Windows contain a fixed number of snapshots that typically represent some period of time.  
 * 
 * This class can be specialized to describe processing of the observations for a particular use-case.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.model.statistical.SDSampleWindow#getView <em>View</em>}</li>
 *   <li>{@link org.eclipse.hyades.model.statistical.SDSampleWindow#getObservations <em>Observations</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.model.statistical.StatisticalPackage#getSDSampleWindow()
 * @model
 * @generated
 */
public interface SDSampleWindow extends EObject{
	/**
	 * Returns the value of the '<em><b>View</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.model.statistical.SDView#getWindow <em>Window</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>View</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>View</em>' container reference.
	 * @see #setView(SDView)
	 * @see org.eclipse.hyades.model.statistical.StatisticalPackage#getSDSampleWindow_View()
	 * @see org.eclipse.hyades.model.statistical.SDView#getWindow
	 * @model opposite="window"
	 * @generated
	 */
	SDView getView();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.model.statistical.SDSampleWindow#getView <em>View</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>View</em>' container reference.
	 * @see #getView()
	 * @generated
	 */
	void setView(SDView value);

	/**
	 * Returns the value of the '<em><b>Observations</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.model.statistical.SDSnapshotObservation}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.model.statistical.SDSnapshotObservation#getWindow <em>Window</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Observations</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Observations</em>' containment reference list.
	 * @see org.eclipse.hyades.model.statistical.StatisticalPackage#getSDSampleWindow_Observations()
	 * @see org.eclipse.hyades.model.statistical.SDSnapshotObservation#getWindow
	 * @model opposite="window" containment="true"
	 * @generated
	 */
	EList<SDSnapshotObservation> getObservations();

} // SDSampleWindow
