/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SDMemberDescriptorImpl.java,v 1.5 2009/05/05 15:49:20 paules Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.model.statistical.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.model.statistical.SDMemberDescriptor;
import org.eclipse.hyades.model.statistical.SDRepresentation;
import org.eclipse.hyades.model.statistical.SDSnapshotObservation;
import org.eclipse.hyades.model.statistical.StatisticalPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>SD Member Descriptor</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.model.statistical.impl.SDMemberDescriptorImpl#getRepresentation <em>Representation</em>}</li>
 *   <li>{@link org.eclipse.hyades.model.statistical.impl.SDMemberDescriptorImpl#getSnapshotObservation <em>Snapshot Observation</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public abstract class SDMemberDescriptorImpl extends SDDescriptorImpl implements SDMemberDescriptor {
	/**
	 * The cached value of the '{@link #getRepresentation() <em>Representation</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRepresentation()
	 * @generated
	 * @ordered
	 */
	protected SDRepresentation representation;

	/**
	 * The cached value of the '{@link #getSnapshotObservation() <em>Snapshot Observation</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSnapshotObservation()
	 * @generated
	 * @ordered
	 */
	protected EList<SDSnapshotObservation> snapshotObservation;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SDMemberDescriptorImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return StatisticalPackage.Literals.SD_MEMBER_DESCRIPTOR;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SDRepresentation getRepresentation() {
		return representation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetRepresentation(SDRepresentation newRepresentation, NotificationChain msgs) {
		SDRepresentation oldRepresentation = representation;
		representation = newRepresentation;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, StatisticalPackage.SD_MEMBER_DESCRIPTOR__REPRESENTATION, oldRepresentation, newRepresentation);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setRepresentation(SDRepresentation newRepresentation) {
		if (newRepresentation != representation) {
			NotificationChain msgs = null;
			if (representation != null)
				msgs = ((InternalEObject)representation).eInverseRemove(this, StatisticalPackage.SD_REPRESENTATION__MEMBER_DESCRIPTOR, SDRepresentation.class, msgs);
			if (newRepresentation != null)
				msgs = ((InternalEObject)newRepresentation).eInverseAdd(this, StatisticalPackage.SD_REPRESENTATION__MEMBER_DESCRIPTOR, SDRepresentation.class, msgs);
			msgs = basicSetRepresentation(newRepresentation, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, StatisticalPackage.SD_MEMBER_DESCRIPTOR__REPRESENTATION, newRepresentation, newRepresentation));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<SDSnapshotObservation> getSnapshotObservation() {
		if (snapshotObservation == null) {
			snapshotObservation = new EObjectWithInverseResolvingEList<SDSnapshotObservation>(SDSnapshotObservation.class, this, StatisticalPackage.SD_MEMBER_DESCRIPTOR__SNAPSHOT_OBSERVATION, StatisticalPackage.SD_SNAPSHOT_OBSERVATION__MEMBER_DESCRIPTOR);
		}
		return snapshotObservation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case StatisticalPackage.SD_MEMBER_DESCRIPTOR__REPRESENTATION:
				if (representation != null)
					msgs = ((InternalEObject)representation).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - StatisticalPackage.SD_MEMBER_DESCRIPTOR__REPRESENTATION, null, msgs);
				return basicSetRepresentation((SDRepresentation)otherEnd, msgs);
			case StatisticalPackage.SD_MEMBER_DESCRIPTOR__SNAPSHOT_OBSERVATION:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getSnapshotObservation()).basicAdd(otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case StatisticalPackage.SD_MEMBER_DESCRIPTOR__REPRESENTATION:
				return basicSetRepresentation(null, msgs);
			case StatisticalPackage.SD_MEMBER_DESCRIPTOR__SNAPSHOT_OBSERVATION:
				return ((InternalEList<?>)getSnapshotObservation()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case StatisticalPackage.SD_MEMBER_DESCRIPTOR__REPRESENTATION:
				return getRepresentation();
			case StatisticalPackage.SD_MEMBER_DESCRIPTOR__SNAPSHOT_OBSERVATION:
				return getSnapshotObservation();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case StatisticalPackage.SD_MEMBER_DESCRIPTOR__REPRESENTATION:
				setRepresentation((SDRepresentation)newValue);
				return;
			case StatisticalPackage.SD_MEMBER_DESCRIPTOR__SNAPSHOT_OBSERVATION:
				getSnapshotObservation().clear();
				getSnapshotObservation().addAll((Collection<? extends SDSnapshotObservation>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case StatisticalPackage.SD_MEMBER_DESCRIPTOR__REPRESENTATION:
				setRepresentation((SDRepresentation)null);
				return;
			case StatisticalPackage.SD_MEMBER_DESCRIPTOR__SNAPSHOT_OBSERVATION:
				getSnapshotObservation().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case StatisticalPackage.SD_MEMBER_DESCRIPTOR__REPRESENTATION:
				return representation != null;
			case StatisticalPackage.SD_MEMBER_DESCRIPTOR__SNAPSHOT_OBSERVATION:
				return snapshotObservation != null && !snapshotObservation.isEmpty();
		}
		return super.eIsSet(featureID);
	}

} //SDMemberDescriptorImpl
