/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: StatisticalFactoryImpl.java,v 1.4 2009/05/05 15:49:20 paules Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.model.statistical.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.hyades.model.statistical.SDContiguousObservation;
import org.eclipse.hyades.model.statistical.SDContiguousRepresentation;
import org.eclipse.hyades.model.statistical.SDCounterDescriptor;
import org.eclipse.hyades.model.statistical.SDDescriptor;
import org.eclipse.hyades.model.statistical.SDDiscreteObservation;
import org.eclipse.hyades.model.statistical.SDDiscreteRepresentation;
import org.eclipse.hyades.model.statistical.SDGaugeRepresentation;
import org.eclipse.hyades.model.statistical.SDRangeRepresentation;
import org.eclipse.hyades.model.statistical.SDSampleDescriptor;
import org.eclipse.hyades.model.statistical.SDSampleWindow;
import org.eclipse.hyades.model.statistical.SDTextObservation;
import org.eclipse.hyades.model.statistical.SDTextRepresentation;
import org.eclipse.hyades.model.statistical.SDView;
import org.eclipse.hyades.model.statistical.StatisticalFactory;
import org.eclipse.hyades.model.statistical.StatisticalPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class StatisticalFactoryImpl extends EFactoryImpl implements StatisticalFactory {
	/**
	 * Creates the default factory implementation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static StatisticalFactory init() {
		try {
			StatisticalFactory theStatisticalFactory = (StatisticalFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/hyades/models/statistical.xmi"); 
			if (theStatisticalFactory != null) {
				return theStatisticalFactory;
			}
		}
		catch (Exception exception) {
			EcorePlugin.INSTANCE.log(exception);
		}
		return new StatisticalFactoryImpl();
	}

	/**
	 * Creates an instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public StatisticalFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
			case StatisticalPackage.SD_DESCRIPTOR: return createSDDescriptor();
			case StatisticalPackage.SD_GAUGE_REPRESENTATION: return createSDGaugeRepresentation();
			case StatisticalPackage.SD_SAMPLE_DESCRIPTOR: return createSDSampleDescriptor();
			case StatisticalPackage.SD_VIEW: return createSDView();
			case StatisticalPackage.SD_SAMPLE_WINDOW: return createSDSampleWindow();
			case StatisticalPackage.SD_DISCRETE_OBSERVATION: return createSDDiscreteObservation();
			case StatisticalPackage.SD_CONTIGUOUS_OBSERVATION: return createSDContiguousObservation();
			case StatisticalPackage.SD_TEXT_OBSERVATION: return createSDTextObservation();
			case StatisticalPackage.SD_RANGE_REPRESENTATION: return createSDRangeRepresentation();
			case StatisticalPackage.SD_COUNTER_DESCRIPTOR: return createSDCounterDescriptor();
			case StatisticalPackage.SD_TEXT_REPRESENTATION: return createSDTextRepresentation();
			case StatisticalPackage.SD_DISCRETE_REPRESENTATION: return createSDDiscreteRepresentation();
			case StatisticalPackage.SD_CONTIGUOUS_REPRESENTATION: return createSDContiguousRepresentation();
			default:
				throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SDDescriptor createSDDescriptor() {
		SDDescriptorImpl sdDescriptor = new SDDescriptorImpl();
		return sdDescriptor;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SDGaugeRepresentation createSDGaugeRepresentation() {
		SDGaugeRepresentationImpl sdGaugeRepresentation = new SDGaugeRepresentationImpl();
		return sdGaugeRepresentation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SDSampleDescriptor createSDSampleDescriptor() {
		SDSampleDescriptorImpl sdSampleDescriptor = new SDSampleDescriptorImpl();
		return sdSampleDescriptor;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SDView createSDView() {
		SDViewImpl sdView = new SDViewImpl();
		return sdView;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SDSampleWindow createSDSampleWindow() {
		SDSampleWindowImpl sdSampleWindow = new SDSampleWindowImpl();
		return sdSampleWindow;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SDDiscreteObservation createSDDiscreteObservation() {
		SDDiscreteObservationImpl sdDiscreteObservation = new SDDiscreteObservationImpl();
		return sdDiscreteObservation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SDContiguousObservation createSDContiguousObservation() {
		SDContiguousObservationImpl sdContiguousObservation = new SDContiguousObservationImpl();
		return sdContiguousObservation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SDTextObservation createSDTextObservation() {
		SDTextObservationImpl sdTextObservation = new SDTextObservationImpl();
		return sdTextObservation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SDRangeRepresentation createSDRangeRepresentation() {
		SDRangeRepresentationImpl sdRangeRepresentation = new SDRangeRepresentationImpl();
		return sdRangeRepresentation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SDCounterDescriptor createSDCounterDescriptor() {
		SDCounterDescriptorImpl sdCounterDescriptor = new SDCounterDescriptorImpl();
		return sdCounterDescriptor;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SDTextRepresentation createSDTextRepresentation() {
		SDTextRepresentationImpl sdTextRepresentation = new SDTextRepresentationImpl();
		return sdTextRepresentation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SDDiscreteRepresentation createSDDiscreteRepresentation() {
		SDDiscreteRepresentationImpl sdDiscreteRepresentation = new SDDiscreteRepresentationImpl();
		return sdDiscreteRepresentation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SDContiguousRepresentation createSDContiguousRepresentation() {
		SDContiguousRepresentationImpl sdContiguousRepresentation = new SDContiguousRepresentationImpl();
		return sdContiguousRepresentation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public StatisticalPackage getStatisticalPackage() {
		return (StatisticalPackage)getEPackage();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @deprecated
	 * @generated
	 */
	@Deprecated
	public static StatisticalPackage getPackage() {
		return StatisticalPackage.eINSTANCE;
	}
} //StatisticalFactoryImpl
